/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.resource;

import com.atlassian.confluence.extra.webdav.ConfluenceDavSession;
import com.atlassian.confluence.extra.webdav.resource.AbstractConfluenceResource;
import com.atlassian.confluence.web.context.StaticHttpContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.SupportedLock;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public abstract class AbstractContentResource
extends AbstractConfluenceResource {
    private static final Predicate<Map.Entry<String, String>> NOT_CONTENT_TYPE_HEADERS = input -> !"Content-Type".equals(input.getKey());

    public AbstractContentResource(DavResourceLocator davResourceLocator, DavResourceFactory davResourceFactory, LockManager lockManager, ConfluenceDavSession davSession) {
        super(davResourceLocator, davResourceFactory, lockManager, davSession);
    }

    protected abstract InputStream getContent();

    protected abstract String getContentType();

    protected abstract long getContentLength();

    protected Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    protected SupportedLock getSupportedLock() {
        SupportedLock supportedLock = new SupportedLock();
        supportedLock.addEntry(Type.WRITE, Scope.EXCLUSIVE);
        return supportedLock;
    }

    public boolean isCollection() {
        return false;
    }

    @Override
    protected void initProperties(DavPropertySet propertySet) {
        super.initProperties(propertySet);
        propertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)this.getContentLength()));
        propertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)this.getContentType()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void spool(OutputContext outputContext) throws IOException {
        if (outputContext.hasStream()) {
            try (OutputStream outputStream = outputContext.getOutputStream();
                 InputStream inputStream = this.getContent();){
                outputContext.setContentLength(this.getContentLength());
                outputContext.setContentType(this.getContentType());
                outputContext.setModificationTime(this.getModificationTime());
                HttpServletResponse response = new StaticHttpContext().getActiveResponse();
                this.getHeaders().entrySet().stream().filter(NOT_CONTENT_TYPE_HEADERS).forEach(header -> response.setHeader((String)header.getKey(), (String)header.getValue()));
                if (inputStream == null || outputStream == null) return;
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                return;
            }
        } else {
            outputContext.setContentLength(0L);
            outputContext.setModificationTime(this.getModificationTime());
        }
    }

    public final DavResourceIterator getMembers() {
        return new DavResourceIteratorImpl(Collections.emptyList());
    }
}

