/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.resource;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSession;
import com.atlassian.confluence.extra.webdav.resource.AbstractPageExportContentResource;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePdfExportContentResourceImpl
extends AbstractPageExportContentResource {
    public static final String CONTENT_TYPE = "application/pdf";
    public static final String DISPLAY_NAME_SUFFIX = ".pdf";
    private static final Logger LOGGER = LoggerFactory.getLogger(PagePdfExportContentResourceImpl.class);
    private final PdfExporterService pdfExporterService;

    public PagePdfExportContentResourceImpl(DavResourceLocator davResourceLocator, DavResourceFactory davResourceFactory, LockManager lockManager, ConfluenceDavSession davSession, @ComponentImport PageManager pageManager, @ComponentImport PdfExporterService pdfExporterService, String spaceKey, String pageTitle) {
        super(davResourceLocator, davResourceFactory, lockManager, davSession, pageManager, spaceKey, pageTitle);
        this.pdfExporterService = pdfExporterService;
    }

    @Override
    public boolean exists() {
        return super.exists() && !((ConfluenceDavSession)this.getSession()).getResourceStates().isContentPdfExportHidden((ContentEntityObject)this.getPage());
    }

    @Override
    protected String getExportSuffix() {
        return DISPLAY_NAME_SUFFIX;
    }

    private File generatePdfExportFromPdfExporterService() throws ImportExportException {
        return this.pdfExporterService.createPdfForPage(AuthenticatedUserThreadLocal.get(), (AbstractPage)this.getPage(), new StaticHttpContext().getActiveRequest().getContextPath());
    }

    @Override
    protected InputStream getContentInternal() {
        try {
            return new BufferedInputStream(Files.newInputStream(this.generatePdfExportFromPdfExporterService().toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            LOGGER.error("Error exporting {} as PDF. Returning InputStream with one byte", (Object)this.getPage(), (Object)e);
            return new ByteArrayInputStream(new byte[1]);
        }
    }

    @Override
    protected String getContentType() {
        return CONTENT_TYPE;
    }

    public String getDisplayName() {
        return this.getPage().getTitle() + DISPLAY_NAME_SUFFIX;
    }
}

