/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.servlet;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.security.xml.SecureXmlParserFactory;
import io.atlassian.util.adapter.jakarta.JakartaAdapters;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavRequestImpl;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.WebdavResponseImpl;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@UnrestrictedAccess
@Component(value="webDavServlet")
@ParametersAreNonnullByDefault
public class ConfluenceWebdavServlet
extends AbstractWebdavServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfluenceWebdavServlet.class);
    private static final String DEFAULT_AUTH_HEADER = "Basic realm=\"Confluence WebDAV Server\"";
    private DavSessionProvider davSessionProvider;
    private DavResourceFactory resourceFactory;
    private DavLocatorFactory locatorFactory;

    @Autowired
    public ConfluenceWebdavServlet(DavSessionProvider davSessionProvider, @Qualifier(value="resourceFactory") DavResourceFactory resourceFactory, DavLocatorFactory locatorFactory) {
        this.davSessionProvider = Objects.requireNonNull(davSessionProvider);
        this.resourceFactory = Objects.requireNonNull(resourceFactory);
        this.locatorFactory = Objects.requireNonNull(locatorFactory);
        DocumentBuilderFactory documentBuilderFactory = SecureXmlParserFactory.newDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setCoalescing(true);
        DomUtil.setBuilderFactory((DocumentBuilderFactory)documentBuilderFactory);
    }

    public DavSessionProvider getDavSessionProvider() {
        return this.davSessionProvider;
    }

    public void setDavSessionProvider(DavSessionProvider davSessionProvider) {
        this.davSessionProvider = Objects.requireNonNull(davSessionProvider);
    }

    public DavResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(DavResourceFactory resourceFactory) {
        this.resourceFactory = Objects.requireNonNull(resourceFactory);
    }

    public DavLocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    public void setLocatorFactory(DavLocatorFactory locatorFactory) {
        this.locatorFactory = Objects.requireNonNull(locatorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        String uri = request.getRequestURI();
        LOGGER.debug("{}, {} {}", new Object[]{request.getHeader("User-Agent"), method, uri});
        WebdavRequestImpl webdavRequest = new WebdavRequestImpl(request, this.getLocatorFactory());
        int methodCode = DavMethods.getMethodCode((String)request.getMethod());
        boolean noCache = DavMethods.isDeltaVMethod((DavServletRequest)webdavRequest) && 20 != methodCode && 19 != methodCode;
        WebdavResponseImpl webdavResponse = new WebdavResponseImpl(response, noCache);
        try {
            ServletActionContext.setRequest((HttpServletRequest)JakartaAdapters.asJakarta((javax.servlet.http.HttpServletRequest)request));
            ServletActionContext.setResponse((jakarta.servlet.http.HttpServletResponse)JakartaAdapters.asJakarta((HttpServletResponse)response));
            if (!this.getDavSessionProvider().attachSession((WebdavRequest)webdavRequest)) {
                throw new DavException(401, "Unable to authenticate.");
            }
            DavResource resource = this.getResourceFactory().createResource(webdavRequest.getRequestLocator(), (DavServletRequest)webdavRequest, (DavServletResponse)webdavResponse);
            if (!this.isPreconditionValid((WebdavRequest)webdavRequest, resource)) {
                webdavResponse.sendError(412);
                return;
            }
            if (!this.execute((WebdavRequest)webdavRequest, (WebdavResponse)webdavResponse, methodCode, resource)) {
                super.service(request, response);
            }
        }
        catch (DavException e) {
            if (e.getErrorCode() == 401) {
                LOGGER.debug("{} {} unauthorized", (Object)method, (Object)uri);
                webdavResponse.setHeader("WWW-Authenticate", this.getAuthenticateHeaderValue());
                webdavResponse.sendError(e.getErrorCode(), e.getStatusPhrase());
            } else if (403 == e.getErrorCode()) {
                LOGGER.debug("{} {} denied: {}", new Object[]{method, uri, e.getMessage()});
                webdavResponse.sendError(e);
            } else {
                LOGGER.error("Unexpected error", (Throwable)e);
                webdavResponse.sendError(e);
            }
        }
        finally {
            this.getDavSessionProvider().releaseSession((WebdavRequest)webdavRequest);
            ServletActionContext.setRequest(null);
            ServletActionContext.setResponse(null);
        }
    }

    protected void doPropFind(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        int depth = request.getDepth(Integer.MAX_VALUE);
        if (depth == Integer.MAX_VALUE) {
            Document document;
            try {
                document = DomUtil.createDocument();
            }
            catch (ParserConfigurationException e) {
                throw new DavException(500, (Throwable)e);
            }
            Element propfindFiniteDepthCondition = DomUtil.createElement((Document)document, (String)"propfind-finite-depth", (Namespace)DavConstants.NAMESPACE);
            throw new DavException(403, "propfind-finite-depth", null, propfindFiniteDepthCondition);
        }
        super.doPropFind(request, response, resource);
    }

    public String getAuthenticateHeaderValue() {
        return DEFAULT_AUTH_HEADER;
    }

    protected boolean isPreconditionValid(WebdavRequest request, DavResource resource) {
        return !resource.exists() || request.matchesIfHeader(resource);
    }
}

