/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public abstract class AbstractHttpFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletResponse httpServletResponse;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            if (servletResponse instanceof HttpServletResponse && this.handles(httpServletRequest, httpServletResponse = (HttpServletResponse)servletResponse)) {
                this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    protected abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected boolean handles(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public void destroy() {
    }
}

