/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.extra.webdav.WebdavSettingsManager;
import com.atlassian.confluence.extra.webdav.servlet.filter.AbstractHttpFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class ClientWriteDenyFilter
extends AbstractHttpFilter {
    private final WebdavSettingsManager webdavSettingsManager;

    public ClientWriteDenyFilter(WebdavSettingsManager webdavSettingsManager) {
        this.webdavSettingsManager = webdavSettingsManager;
    }

    private boolean isWebdavClientDenied(String userAgent, String method) {
        return (method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("COPY") || method.equalsIgnoreCase("DELETE") || method.equalsIgnoreCase("MKCOL") || method.equalsIgnoreCase("MOVE")) && this.webdavSettingsManager.isClientInWriteBlacklist(userAgent);
    }

    @Override
    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isWebdavClientDenied(StringUtils.defaultString((String)httpServletRequest.getHeader("User-Agent")), httpServletRequest.getMethod())) {
            httpServletResponse.setStatus(403);
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }
}

