/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.extra.webdav.servlet.filter.AbstractHttpFilter;
import com.atlassian.confluence.extra.webdav.util.UserAgentUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class MicrosoftMiniRedirectorAuthenticationHeaderFix
extends AbstractHttpFilter {
    private HttpServletRequest rewriteDestinationHeader(HttpServletRequest httpServletRequest) throws ServletException {
        String authorizationHeader = httpServletRequest.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            int indexOfBackSlash;
            Object[] authTokens = StringUtils.split((String)StringUtils.trim((String)authorizationHeader), (char)' ');
            if (authTokens.length != 2) {
                throw new ServletException("Malformed Authorization header: " + StringUtils.join((Object[])authTokens));
            }
            String credentials = new String(Base64.decodeBase64((byte[])((String)authTokens[1]).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            Object[] credentialTokens = StringUtils.split((String)credentials, (char)':');
            if (credentialTokens.length == 2 && (indexOfBackSlash = credentialTokens[0].indexOf(92)) >= 0 && indexOfBackSlash < credentialTokens[0].length() - 1) {
                credentialTokens[0] = credentialTokens[0].substring(indexOfBackSlash + 1);
                credentials = new String(Base64.encodeBase64((byte[])StringUtils.join((Object[])credentialTokens, (char)':').getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                return new HttpServletRequestWrapperWithModifiedAuthorizationHeader(httpServletRequest, StringUtils.join((Object[])new String[]{authTokens[0], credentials}, (char)' '));
            }
        }
        return httpServletRequest;
    }

    @Override
    protected boolean handles(HttpServletRequest request, HttpServletResponse response) {
        return UserAgentUtil.isMicrosoftMiniRedirector(request.getHeader("User-Agent"));
    }

    @Override
    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)this.rewriteDestinationHeader(httpServletRequest), (ServletResponse)httpServletResponse);
    }

    private static class HttpServletRequestWrapperWithModifiedAuthorizationHeader
    extends HttpServletRequestWrapper {
        private final String authorizationHeaderValue;

        public HttpServletRequestWrapperWithModifiedAuthorizationHeader(HttpServletRequest httpServletRequest, String authorizationHeaderValue) {
            super(httpServletRequest);
            this.authorizationHeaderValue = authorizationHeaderValue;
        }

        public String getHeader(String name) {
            if (StringUtils.equals((CharSequence)"Authorization", (CharSequence)name)) {
                return this.authorizationHeaderValue;
            }
            return super.getHeader(name);
        }
    }
}

