/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.extra.webdav.servlet.filter.AbstractPrefixAwareFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class ReverseProxyCopyAndMoveDestinationFix
extends AbstractPrefixAwareFilter {
    private static final Pattern GLOBAL_RESOURCE_PATTERN = Pattern.compile("/(\\bGlobal\\b|\\bPersonal\\b)");

    private boolean isCopyOrMoveMethod(HttpServletRequest httpServletRequest) {
        return StringUtils.equals((CharSequence)httpServletRequest.getMethod(), (CharSequence)"MOVE") || StringUtils.equals((CharSequence)httpServletRequest.getMethod(), (CharSequence)"COPY");
    }

    private HttpServletRequest rewriteDestinationHeader(HttpServletRequest httpServletRequest) {
        Matcher globalResourcePatternMatcher;
        String destination = httpServletRequest.getHeader("Destination");
        if (StringUtils.isNotBlank((CharSequence)destination) && (globalResourcePatternMatcher = GLOBAL_RESOURCE_PATTERN.matcher(destination)).find()) {
            String rewrittenDestination = new StringBuffer().append(httpServletRequest.getScheme()).append("://").append(httpServletRequest.getHeader("Host")).append(httpServletRequest.getContextPath()).append(this.getPrefix()).append(destination.substring(globalResourcePatternMatcher.start())).toString();
            return new HttpServletRequestWrapperWithModifiedDestinationHeader(httpServletRequest, rewrittenDestination);
        }
        return httpServletRequest;
    }

    @Override
    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)(this.isCopyOrMoveMethod(httpServletRequest) ? this.rewriteDestinationHeader(httpServletRequest) : httpServletRequest), (ServletResponse)httpServletResponse);
    }

    private static class HttpServletRequestWrapperWithModifiedDestinationHeader
    extends HttpServletRequestWrapper {
        private final String destinationHeaderValue;

        public HttpServletRequestWrapperWithModifiedDestinationHeader(HttpServletRequest httpServletRequest, String destinationHeaderValue) {
            super(httpServletRequest);
            this.destinationHeaderValue = destinationHeaderValue;
        }

        public String getHeader(String name) {
            if (StringUtils.equals((CharSequence)"Destination", (CharSequence)name)) {
                return this.destinationHeaderValue;
            }
            return super.getHeader(name);
        }
    }
}

