/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.extra.webdav.servlet.filter.AbstractPrefixAwareFilter;
import com.atlassian.confluence.extra.webdav.util.ResourceHelper;
import com.atlassian.confluence.extra.webdav.util.UserAgentUtil;
import com.atlassian.confluence.util.FilesystemUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class WebdavRequestForwardFilter
extends AbstractPrefixAwareFilter {
    private static final Logger logger = LoggerFactory.getLogger(WebdavRequestForwardFilter.class);
    private String mountPointPrefix;
    private FilterConfig filterConfig;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
        this.mountPointPrefix = StringUtils.defaultString((String)filterConfig.getInitParameter("mount-point-prefix"));
    }

    @Override
    protected boolean handles(HttpServletRequest request, HttpServletResponse response) {
        String userAgent = request.getHeader("User-Agent");
        return !UserAgentUtil.isOsxFinder(userAgent) && StringUtils.isEmpty((CharSequence)request.getContextPath());
    }

    @Override
    public void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        String originalUri = httpServletRequest.getRequestURI();
        if (FilesystemUtils.containsEncodedPathTraversal((String)originalUri)) {
            httpServletResponse.sendError(400);
            return;
        }
        if (StringUtils.startsWith((CharSequence)originalUri, (CharSequence)this.mountPointPrefix)) {
            String targetPath = this.getPrefix() + originalUri.substring(this.mountPointPrefix.length());
            if (ResourceHelper.containsPathTraversal(targetPath)) {
                throw new UnsupportedEncodingException("Potential Path traversal detected");
            }
            logger.debug("Forwarding webdav request to WebDavServlet on path :{}", (Object)targetPath);
            this.filterConfig.getServletContext().getRequestDispatcher(targetPath).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)httpServletRequest.getMethod(), (CharSequence)"OPTIONS") && StringUtils.equals((CharSequence)"/", (CharSequence)originalUri)) {
            httpServletResponse.addHeader("MS-Author-Via", "DAV");
            httpServletResponse.setStatus(200);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

