/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.upgrade;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.extra.webdav.WebdavSettings;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.confluence.setup.xstream.ConfluenceXStream;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PluginUpgradeTask.class})
public class BandanaRemovalUpgradeTask
implements PluginUpgradeTask {
    private static final int BUILD_NUMBER = 2;
    private static final Logger log = LoggerFactory.getLogger(BandanaRemovalUpgradeTask.class);
    private final BandanaContext bandanaContext = new NoParentBandanaContext("com.atlassian.confluence.extra.webdav.sessions");
    private final BandanaManager bandanaManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ResettableLazyReference<ConfluenceXStream> pluginXStream;
    private final ConfluenceJsonObjectMapper objectMapper = new ConfluenceJsonObjectMapper();

    public BandanaRemovalUpgradeTask(@ComponentImport @Qualifier(value="bandanaManager") BandanaManager bandanaManager, @ComponentImport @Qualifier(value="extendedPluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory, @ComponentImport ConfluenceXStreamManager xStreamManager) {
        this.bandanaManager = bandanaManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginXStream = Lazy.resettable(() -> xStreamManager.getPluginXStream(this.getClass().getClassLoader()));
    }

    public int getBuildNumber() {
        return 2;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrate Bandana records to Plugin Settings in confluence-webdav-plugin.";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        log.info("Starting migration of Bandana records to Plugin Settings for WebDAV.");
        this.migrateWebDavSettings();
        this.migrateWebDavSessions();
        log.info("Finished migration of Bandana records to Plugin Settings for WebDAV.");
        return List.of();
    }

    private void migrateWebDavSessions() {
        log.info("WebDav Session Bandana to Plugin Settings migration.");
        Iterable keys = this.bandanaManager.getKeys(this.bandanaContext);
        keys.forEach(key -> {
            log.info("Migrate WebDav Session for user: {}", key);
            Object userSession = this.bandanaManager.getValue(this.bandanaContext, key);
            try {
                String serializedSettings = this.objectMapper.writeValueAsString(userSession);
                this.pluginSettingsFactory.createSettingsForKey("com.atlassian.confluence.extra.webdav.sessions").put(key, (Object)serializedSettings);
                log.info("Successfully migrated WebDav Session for user: {}", key);
            }
            catch (Exception e) {
                log.error("Failed to migrate WebDav Session for user: {}", key, (Object)e);
            }
        });
    }

    private void migrateWebDavSettings() {
        log.info("Migrating WebDAV settings.");
        WebdavSettings webDavSettings = this.getWebDavSettingsFromBandana();
        if (webDavSettings != null) {
            try {
                String serializedSettings = this.objectMapper.writeValueAsString((Object)webDavSettings);
                this.pluginSettingsFactory.createGlobalSettings().put("com.atlassian.confluence.extra.webdav-2.0.settings", (Object)serializedSettings);
                log.info("Successfully migrated WebDAV settings to Plugin Settings.");
            }
            catch (Exception e) {
                log.error("Failed to migrate WebDAV settings to Plugin Settings.", (Throwable)e);
            }
        } else {
            log.info("No WebDAV settings found in Bandana.");
        }
    }

    private WebdavSettings getWebDavSettingsFromBandana() {
        String webdavSettingsXml;
        Object setting = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "com.atlassian.confluence.extra.webdav-2.0.settings");
        if (setting instanceof WebdavSettings) {
            WebdavSettings webdavSettings = (WebdavSettings)setting;
            return webdavSettings;
        }
        if (setting instanceof String && StringUtils.isNotBlank((CharSequence)(webdavSettingsXml = (String)setting))) {
            return (WebdavSettings)((ConfluenceXStream)this.pluginXStream.get()).fromXML(webdavSettingsXml);
        }
        return null;
    }

    @Nonnull
    public String getPluginKey() {
        return "confluence.extra.webdav";
    }
}

