/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.webdav.util.WebdavConstants;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.util.FileTypeUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.webdav.io.InputContext;

public class ResourceHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getInputContextContentAsFile(InputContext inputContext) throws IOException {
        File file;
        File tempFile = File.createTempFile("webdav", null);
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = inputContext.getInputStream();
            out = new BufferedOutputStream(new FileOutputStream(tempFile));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            file = tempFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdateAttachment(AttachmentManager attachmentManager, ContentEntityObject ceo, String fileName, InputContext inputContext) throws IOException {
        Attachment attachment = attachmentManager.getAttachment(ceo, fileName);
        Attachment previousVersionOfAttachment = null;
        File inputContentFile = null;
        BufferedInputStream inputContentStream = null;
        if (null == attachment) {
            attachment = new Attachment();
        } else {
            previousVersionOfAttachment = (Attachment)attachment.clone();
        }
        try {
            inputContentFile = ResourceHelper.getInputContextContentAsFile(inputContext);
            if (!fileName.startsWith("._") && inputContentFile.length() > 0L || fileName.startsWith("._") || !attachment.isPersistent()) {
                ConfluenceUser user = AuthenticatedUserThreadLocal.get();
                attachment.setFileName(fileName);
                attachment.setFileSize(inputContentFile.length());
                attachment.setCreator(user);
                attachment.setCreationDate(new Date());
                attachment.setLastModifier(user);
                attachment.setLastModificationDate(attachment.getCreationDate());
                attachment.setContainer(ceo);
                attachment.setMediaType(StringUtils.isBlank((CharSequence)inputContext.getContentType()) ? FileTypeUtil.getContentType((String)fileName) : inputContext.getContentType());
                ceo.addAttachment(attachment);
                inputContentStream = new BufferedInputStream(new FileInputStream(inputContentFile));
                attachmentManager.saveAttachment(attachment, previousVersionOfAttachment, (InputStream)inputContentStream);
            }
        }
        finally {
            IOUtils.closeQuietly(inputContentStream);
            if (null != inputContentFile) {
                inputContentFile.delete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsPathTraversal(String str) {
        if (WebdavConstants.FORBIDDEN_PATH_EQUALS.stream().anyMatch(str::equals)) return true;
        if (WebdavConstants.FORBIDDEN_PATH_CONTAINS.stream().anyMatch(str::contains)) return true;
        if (!WebdavConstants.FORBIDDEN_PATH_ENDINGS.stream().anyMatch(str::endsWith)) return false;
        return true;
    }
}

