/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.io.Serializable;
import java.util.UUID;
import org.apache.jackrabbit.webdav.lock.AbstractActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;

public class SerializableActiveLock
extends AbstractActiveLock
implements Serializable {
    private final String token = "opaquelocktoken:" + String.valueOf(UUID.randomUUID());
    private String owner;
    private boolean isDeep = true;
    private long expirationTime = Integer.MAX_VALUE;

    public SerializableActiveLock() {
    }

    public SerializableActiveLock(LockInfo lockInfo) {
        if (lockInfo != null) {
            if (!Type.WRITE.equals((Object)lockInfo.getType()) || !Scope.EXCLUSIVE.equals((Object)lockInfo.getScope())) {
                throw new IllegalArgumentException("Only 'exclusive write' lock is allowed scope/type pair.");
            }
            this.owner = lockInfo.getOwner();
            this.isDeep = lockInfo.isDeep();
            this.setTimeout(lockInfo.getTimeout());
        }
    }

    public boolean isLockedByToken(String lockToken) {
        return this.token != null && this.token.equals(lockToken);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTime;
    }

    public String getToken() {
        return this.token;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getTimeout() {
        return this.expirationTime - System.currentTimeMillis();
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.expirationTime = System.currentTimeMillis() + timeout;
        }
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public void setIsDeep(boolean isDeep) {
        this.isDeep = isDeep;
    }

    public Type getType() {
        return Type.WRITE;
    }

    public Scope getScope() {
        return Scope.EXCLUSIVE;
    }
}

