/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.user.profile;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.user.actions.UserAware;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.confluence.userstatus.StatusTextRenderer;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbAware;
import com.atlassian.confluence.util.breadcrumbs.UserProfileActionBreadcrumb;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public abstract class AbstractUserProfileAction
extends ConfluenceActionSupport
implements BreadcrumbAware,
UserAware {
    private ConfluenceUser user;
    private PersonalInformation personalInformationEntity;
    private String personalInformation;
    private List<Attachment> attachments;
    protected StatusTextRenderer statusTextRenderer;
    protected WikiStyleRenderer wikiStyleRenderer;
    protected FollowManager followManager;
    protected FavouriteManager favouriteManager;
    protected NotificationManager notificationManager;
    protected PersonalInformationManager personalInformationManager;
    protected AttachmentManager attachmentManager;
    protected SpaceManager spaceManager;
    protected UserDetailsManager userDetailsManager;

    public ConfluenceUser getUser() {
        if (this.user == null && StringUtils.isNotEmpty((CharSequence)this.getUsername())) {
            this.user = this.userAccessor.getUserByName(this.getUsername());
        }
        return this.user;
    }

    public Object getFullName() {
        return this.getUser() == null ? null : this.getUser().getFullName();
    }

    public Object getEmail() {
        return this.getUser() == null ? null : this.getUser().getEmail();
    }

    protected UserPreferences getUserPreferences() {
        return this.userAccessor.getUserPreferences(this.user);
    }

    public PersonalInformation getPersonalInformationEntity() {
        ConfluenceUser user = this.getUser();
        if (this.personalInformationEntity == null && user != null) {
            this.personalInformationEntity = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        }
        return this.personalInformationEntity;
    }

    public String getPersonalInformation() {
        PersonalInformation pi;
        if (this.personalInformation == null && (pi = this.getPersonalInformationEntity()) != null) {
            this.personalInformation = pi.getBodyAsString();
        }
        return this.personalInformation;
    }

    @StrutsParameter
    public void setPersonalInformation(String personalInformation) {
        this.personalInformation = personalInformation;
    }

    public String getUsername() {
        return this.getAuthenticatedUser() == null ? null : this.getAuthenticatedUser().getName();
    }

    public boolean isMyProfile() {
        return this.getPersonalInformationEntity().belongsTo((User)this.getAuthenticatedUser());
    }

    public ProfilePictureInfo getUserProfilePicture() {
        return this.userAccessor.getUserProfilePicture((User)this.getAuthenticatedUser());
    }

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            if (this.getPersonalInformationEntity() == null) {
                return null;
            }
            this.attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)this.getPersonalInformationEntity());
        }
        return this.attachments;
    }

    public final void setAttachmentManager(@ComponentImport AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public final void setNotificationManager(@ComponentImport NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public final void setPersonalInformationManager(@ComponentImport PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public final void setSpaceManager(@ComponentImport SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    protected String getPersonalSpaceKey(ConfluenceUser user) {
        return "~" + user.getName();
    }

    public String getPageTitle() {
        return this.getUser().getFullName();
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        result.setParameter("personalInformationEntity", (Object)this.getPersonalInformationEntity());
        result.setParameter("statusTextRenderer", (Object)this.getStatusTextRenderer());
        result.setPersonalInformation(this.getPersonalInformationEntity());
        return result;
    }

    public boolean isHasAboutMe() {
        return StringUtils.isNotBlank((CharSequence)this.getPersonalInformation());
    }

    public Object getRenderedAboutMe() {
        String pi = this.getPersonalInformation();
        if (pi == null) {
            return null;
        }
        return new HtmlFragment((Object)this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext((ContentEntityObject)this.getPersonalInformationEntity()), pi));
    }

    public Breadcrumb getBreadcrumb() {
        return new UserProfileActionBreadcrumb((ConfluenceActionSupport)this);
    }

    public Object getUserProperty(String key) {
        return new HtmlFragment((Object)this.userDetailsManager.getStringProperty((User)this.getUser(), key));
    }

    public final void setUserDetailsManager(@ComponentImport UserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    public final void setWikiStyleRenderer(@ComponentImport WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public final void setFollowManager(FollowManager followManager) {
        this.followManager = followManager;
    }

    public final void setFavouriteManager(@ComponentImport FavouriteManager favouriteManager) {
        this.favouriteManager = favouriteManager;
    }

    public StatusTextRenderer getStatusTextRenderer() {
        return this.statusTextRenderer;
    }

    public void setStatusTextRenderer(@ComponentImport StatusTextRenderer statusTextRenderer) {
        this.statusTextRenderer = statusTextRenderer;
    }

    public boolean isFollowing() {
        return this.followManager.isUserFollowing((User)this.getAuthenticatedUser(), (User)this.getUser());
    }

    public boolean isFavourite() {
        Space personalSpace = this.spaceManager.getPersonalSpace(this.getUser());
        return this.favouriteManager.isUserFavourite(this.getAuthenticatedUser(), personalSpace);
    }

    public boolean hasPersonalSpace() {
        return this.spaceManager.getPersonalSpace(this.getUser()) != null;
    }

    public boolean currentUserHasLicensedAccess() {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return currentUser != null && this.confluenceAccessManager.getUserAccessStatus(currentUser).hasLicensedAccess();
    }

    public final boolean isUserRequired() {
        return true;
    }

    public final boolean isViewPermissionRequired() {
        return true;
    }
}

