/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.user.profile.rest;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.plugins.user.profile.UserAvatarService;
import com.atlassian.confluence.plugins.user.profile.rest.UserAvatar;
import com.atlassian.confluence.rpc.NotPermittedException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@Path(value="/{userKey}/avatar")
@Produces(value={"application/json"})
public class UserAvatarResource {
    private final UserAvatarService userAvatarService;

    @Inject
    public UserAvatarResource(UserAvatarService userAvatarService) {
        this.userAvatarService = userAvatarService;
    }

    @GET
    @Path(value="default")
    public Response getDefaultLogo() {
        return Response.ok().build();
    }

    @POST
    @LimitRequestSize(value=0x500000L)
    @Consumes(value={"application/json"})
    @Path(value="upload")
    public Response setUploadedAvatar(@PathParam(value="userKey") String userKey, AvatarDetails avatarDetails) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)avatarDetails.getAvatarDataURI())) {
                Attachment avatar = this.userAvatarService.saveAvatar(userKey, avatarDetails.getAvatarDataURI());
                return Response.ok((Object)new UserAvatar(avatar.getDownloadPath())).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotPermittedException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    public Response delete(@PathParam(value="userKey") String userKey) {
        try {
            this.userAvatarService.delete(userKey);
            return Response.ok().build();
        }
        catch (NotPermittedException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @XmlRootElement
    private static class AvatarDetails {
        @XmlElement
        private String avatarDataURI;

        private AvatarDetails() {
        }

        public String getAvatarDataURI() {
            return this.avatarDataURI;
        }
    }
}

