/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.neops;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class NeoPropertySetItem {
    private String entityName;
    private long entityId;
    private String key;
    private int type;
    private String textVal;
    private boolean booleanVal;
    private long longVal;
    private double doubleVal;
    private Date dateVal;

    public NeoPropertySetItem() {
    }

    public NeoPropertySetItem(String entityName, long entityId, String key) {
        this.entityName = entityName;
        this.entityId = entityId;
        this.key = key;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public PropertyType getPropertyType() {
        return PropertyType.fromId(this.type);
    }

    protected void setPropertyType(PropertyType type) {
        this.type = type.id();
    }

    protected void clearValues() {
        this.textVal = null;
        this.booleanVal = false;
        this.longVal = 0L;
        this.doubleVal = 0.0;
        this.dateVal = null;
    }

    protected void validateGetter(PropertyType expectedType) {
        if (!expectedType.equals((Object)this.getPropertyType())) {
            throw new IncorrectPropertyTypeException(expectedType, this.getPropertyType());
        }
    }

    public String getTextVal() {
        this.validateGetter(PropertyType.TEXT);
        return this.textVal;
    }

    public void setTextVal(String textVal) {
        this.clearValues();
        this.textVal = textVal;
        this.setPropertyType(PropertyType.TEXT);
    }

    public boolean getBooleanVal() {
        this.validateGetter(PropertyType.BOOLEAN);
        return this.booleanVal;
    }

    public void setBooleanVal(boolean booleanVal) {
        this.clearValues();
        this.booleanVal = booleanVal;
        this.setPropertyType(PropertyType.BOOLEAN);
    }

    public long getLongVal() {
        this.validateGetter(PropertyType.LONG);
        return this.longVal;
    }

    public void setLongVal(long longVal) {
        this.clearValues();
        this.longVal = longVal;
        this.setPropertyType(PropertyType.LONG);
    }

    public double getDoubleVal() {
        this.validateGetter(PropertyType.DOUBLE);
        return this.doubleVal;
    }

    public void setDoubleVal(double doubleVal) {
        this.clearValues();
        this.doubleVal = doubleVal;
        this.setPropertyType(PropertyType.DOUBLE);
    }

    public Date getDateVal() {
        this.validateGetter(PropertyType.DATE);
        return this.dateVal;
    }

    public void setDateVal(Date dateVal) {
        this.clearValues();
        this.dateVal = dateVal;
        this.setPropertyType(PropertyType.DATE);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NeoPropertySetItem)) {
            return false;
        }
        NeoPropertySetItem other = (NeoPropertySetItem)obj;
        return Objects.equals(other.entityId, this.entityId) && Objects.equals(other.entityName, this.entityName) && Objects.equals(other.key, this.key);
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.entityName, this.key);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entityName", (Object)this.entityName).append("entityId", this.entityId).append("key", (Object)this.key).append("type", this.type).append("textVal", (Object)this.textVal).append("booleanVal", this.booleanVal).append("longVal", this.longVal).append("doubleVal", this.doubleVal).append("dateVal", (Object)this.dateVal).toString();
    }

    public static enum PropertyType {
        UNDEFINED,
        BOOLEAN,
        INT,
        LONG,
        DOUBLE,
        STRING,
        TEXT,
        DATE,
        OBJECT,
        XML,
        DATA,
        PROPERTIES;


        public int id() {
            return this.ordinal();
        }

        public static PropertyType fromId(int id) {
            if (id < 0 || id >= PropertyType.values().length) {
                return UNDEFINED;
            }
            return PropertyType.values()[id];
        }
    }

    public static class IncorrectPropertyTypeException
    extends RuntimeException {
        IncorrectPropertyTypeException(PropertyType attemptedType, PropertyType actualType) {
            super("Attempted to get property type " + String.valueOf((Object)attemptedType) + " but actual type is " + String.valueOf((Object)actualType));
        }
    }
}

