/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.LikeEntity;
import com.atlassian.confluence.persistence.JpaQueryFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeContentQueries;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Pair;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultEdgeContentQueries
implements EdgeContentQueries {
    static final String LIKES_SINCE_QUERY = "select l.content, l from LikeEntity l where l.creationDate > :startDate";
    static final String CONTENT_SINCE_QUERY = "from ContentEntityObject content\nwhere content.originalVersion is null and\ncontent.contentStatus = 'current' and\n(type(content) = com.atlassian.confluence.pages.Page or\ntype(content) = com.atlassian.confluence.pages.BlogPost or\ntype(content) = com.atlassian.confluence.pages.Comment) and content.creationDate > :startDate";
    private final JpaQueryFactory jpaQueryFactory;

    @Autowired
    public DefaultEdgeContentQueries(@ComponentImport JpaQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    @Override
    public List<Pair<ContentEntityObject, LikeEntity>> getLikesSince(Date startDate) {
        Query query = this.jpaQueryFactory.createQuery(LIKES_SINCE_QUERY);
        List results = query.setParameter("startDate", startDate, TemporalType.DATE).getResultList();
        ArrayList<Pair<ContentEntityObject, LikeEntity>> likes = new ArrayList<Pair<ContentEntityObject, LikeEntity>>();
        for (Object[] result : results) {
            Pair contentWithLike = new Pair((Object)((ContentEntityObject)result[0]), (Object)((LikeEntity)result[1]));
            likes.add((Pair<ContentEntityObject, LikeEntity>)contentWithLike);
        }
        return likes;
    }

    @Override
    public List<ContentEntityObject> getContentCreatedSince(Date startDate) {
        TypedQuery query = this.jpaQueryFactory.createQuery(CONTENT_SINCE_QUERY, ContentEntityObject.class);
        return query.setParameter("startDate", startDate, TemporalType.DATE).getResultList();
    }
}

