/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.edgeindex.EdgeDocumentFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexFieldMappings;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.ContentPermissionCalculator;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultEdgeDocumentFactory
implements EdgeDocumentFactory {
    private final ContentPermissionCalculator contentPermissionCalculator;

    @Autowired
    public DefaultEdgeDocumentFactory(@ComponentImport ContentPermissionCalculator contentPermissionCalculator) {
        this.contentPermissionCalculator = contentPermissionCalculator;
    }

    @Override
    public AtlassianDocument buildDocument(String edgeId, UserKey userKey, ContentEntityObject target, Date date, String edgeTypeKey) {
        ConfluenceUser targetAuthor;
        AtlassianDocument document = new AtlassianDocument();
        document.addField(EdgeIndexFieldMappings.EDGE_USERKEY.createField(userKey == null ? "" : (String)StringUtils.defaultIfBlank((CharSequence)userKey.getStringValue(), (CharSequence)"")));
        document.addField(EdgeIndexFieldMappings.EDGE_TARGET_ID.createField(String.valueOf(this.getTargetId(target))));
        long dateInSeconds = date.getTime() / 1000L;
        document.addField(EdgeIndexFieldMappings.EDGE_DATE_FIELD.createField(dateInSeconds));
        document.addField(EdgeIndexFieldMappings.EDGE_TYPE.createField(edgeTypeKey));
        if (edgeId != null) {
            document.addField(EdgeIndexFieldMappings.EDGE_ID.createField(edgeId));
        }
        document.addField(EdgeIndexFieldMappings.EDGE_TARGET_AUTHOR.createField((targetAuthor = this.getTargetAuthor(target)) == null ? "" : targetAuthor.getKey().getStringValue()));
        document.addField(EdgeIndexFieldMappings.EDGE_TARGET_TYPE.createField(this.getTargetType(target)));
        String spaceKey = this.getSpaceKey(target);
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            document.addField(EdgeIndexFieldMappings.SPACE_KEY.createField(this.getSpaceKey(target)));
        } else {
            document.addField(EdgeIndexFieldMappings.IN_SPACE.createField(false));
        }
        Collection permissions = this.contentPermissionCalculator.calculate(target);
        if (!permissions.isEmpty()) {
            document.addFields(EdgeIndexFieldMappings.PERMISSION_SETS.createFields(permissions));
        }
        return document;
    }

    private String getSpaceKey(Object target) {
        if (!(target instanceof Spaced)) {
            return null;
        }
        Space space = ((Spaced)target).getSpace();
        return space != null ? space.getKey() : null;
    }

    private long getTargetId(Object target) {
        if (target instanceof ContentEntityObject) {
            return ((ContentEntityObject)target).getId();
        }
        throw new UnsupportedOperationException("this target object is not supported: " + String.valueOf(target));
    }

    private ConfluenceUser getTargetAuthor(Object target) {
        if (target instanceof ContentEntityObject) {
            return ((ContentEntityObject)target).getCreator();
        }
        return null;
    }

    private String getTargetType(Object target) {
        if (target instanceof CustomContentEntityObject) {
            return ((CustomContentEntityObject)target).getPluginModuleKey();
        }
        if (target instanceof ContentEntityObject) {
            return ((ContentEntityObject)target).getType();
        }
        throw new UnsupportedOperationException("this target object is not supported: " + String.valueOf(target));
    }
}

