/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.plugins.edgeindex.EdgeIndexBuilder;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexManager;
import com.atlassian.confluence.plugins.edgeindex.EdgeSearchIndexAccessor;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="edgeIndexBuilder")
public class DefaultEdgeIndexBuilder
implements EdgeIndexBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeIndexBuilder.class);
    private final EdgeIndexManager edgeIndexManager;
    private final EdgeSearchIndexAccessor edgeSearchIndexAccessor;

    @Autowired
    public DefaultEdgeIndexBuilder(EdgeIndexManager edgeIndexManager, EdgeSearchIndexAccessor edgeSearchIndexAccessor) {
        this.edgeIndexManager = Objects.requireNonNull(edgeIndexManager);
        this.edgeSearchIndexAccessor = Objects.requireNonNull(edgeSearchIndexAccessor);
    }

    @Override
    public void rebuild(Period since, EdgeIndexBuilder.RebuildCondition rebuildCondition) {
        if (rebuildCondition == EdgeIndexBuilder.RebuildCondition.ONLY_IF_INDEX_PRESENT && this.getExistingDocumentCount() == 0) {
            log.info("No existing documents in edge index, skipping reindex");
            return;
        }
        this.edgeIndexManager.reindex(new DateTime().minus((ReadablePeriod)since).toDate());
    }

    private int getExistingDocumentCount() {
        return this.edgeSearchIndexAccessor.numDocs();
    }
}

