/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.LikeEntity;
import com.atlassian.confluence.plugins.edgeindex.EdgeContentQueries;
import com.atlassian.confluence.plugins.edgeindex.EdgeFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeReindexer;
import com.atlassian.confluence.plugins.edgeindex.EdgeSearchIndexAccessor;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.plugins.edgeindex.servlet.EdgeIndexRebuiltEvent;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Pair;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="edgeReindexer")
public class DefaultEdgeReindexer
implements EdgeReindexer {
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeReindexer.class);
    private final EdgeFactory edgeFactory;
    private final EdgeContentQueries edgeContentQueries;
    private final EdgeSearchIndexAccessor edgeSearchIndexAccessor;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultEdgeReindexer(EdgeFactory edgeFactory, EdgeContentQueries edgeContentQueries, EdgeSearchIndexAccessor edgeSearchIndexAccessor, @ComponentImport EventPublisher eventPublisher) {
        this.edgeFactory = Objects.requireNonNull(edgeFactory);
        this.edgeContentQueries = Objects.requireNonNull(edgeContentQueries);
        this.edgeSearchIndexAccessor = Objects.requireNonNull(edgeSearchIndexAccessor);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @Override
    public void reindex(Date startDate, String username, Consumer<Edge> indexAction) {
        this.deleteExistingDocuments();
        List<ContentEntityObject> contentEntities = this.edgeContentQueries.getContentCreatedSince(startDate);
        this.addContentToIndex(contentEntities, indexAction);
        this.addLikesToIndex(startDate, indexAction);
        this.eventPublisher.publish((Object)new EdgeIndexRebuiltEvent(Period.fieldDifference((ReadablePartial)LocalDate.fromDateFields((Date)startDate), (ReadablePartial)LocalDate.now()), username));
    }

    private void addLikesToIndex(Date startDate, Consumer<Edge> indexAction) {
        List<Pair<ContentEntityObject, LikeEntity>> likes = this.edgeContentQueries.getLikesSince(startDate);
        likes.forEach(like -> {
            ContentEntityObject contentEntity = (ContentEntityObject)like.left();
            LikeEntity likeEntity = (LikeEntity)like.right();
            Edge likeEdge = this.edgeFactory.getLikeEdge(likeEntity.getUser(), contentEntity, likeEntity.getCreationDate());
            try {
                indexAction.accept(likeEdge);
            }
            catch (Exception e) {
                log.warn("Error building edge for: {}", (Object)contentEntity);
            }
        });
    }

    private void addContentToIndex(List<ContentEntityObject> contentEntities, Consumer<Edge> indexAction) {
        for (ContentEntityObject contentEntity : contentEntities) {
            try {
                Edge edge;
                if (!this.edgeFactory.canBuildCreatEdge(contentEntity) || (edge = this.edgeFactory.getCreateEdge(contentEntity)) == null) continue;
                indexAction.accept(edge);
            }
            catch (Exception e) {
                log.warn("Error building edge for: {}", (Object)contentEntity);
            }
        }
    }

    private void deleteExistingDocuments() {
        this.edgeSearchIndexAccessor.execute(SearchIndexWriter::deleteAll);
    }
}

