/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.index.IndexJournalService;
import com.atlassian.confluence.api.service.journal.EntryProcessorResult;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.persistence.NonFlushingSessionWrapper;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexTask;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexTaskFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexTaskQueue;
import com.atlassian.confluence.plugins.edgeindex.IndexTaskType;
import com.atlassian.confluence.plugins.edgeindex.IndexableEdge;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.plugins.edgeindex.tasks.RebuildIndexTask;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JournalEdgeIndexTaskQueue
implements EdgeIndexTaskQueue {
    private static final Logger log = LoggerFactory.getLogger(JournalEdgeIndexTaskQueue.class);
    static final JournalIdentifier JOURNAL_ID = new JournalIdentifier("edge_index");
    @VisibleForTesting
    static final int CLEAR_SESSION_BATCH_SIZE = 100;
    public static final int BATCH_SIZE = 1000;
    private final IndexJournalService journalService;
    private final EdgeIndexTaskFactory edgeIndexTaskFactory;
    private final TransactionTemplate transactionTemplate;
    private final NonFlushingSessionWrapper nonFlushingSessionWrapper;
    private final ObjectMapper jsonMapper;

    @Autowired
    public JournalEdgeIndexTaskQueue(@ComponentImport IndexJournalService journalService, EdgeIndexTaskFactory edgeIndexTaskFactory, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport NonFlushingSessionWrapper hibernateNonFlushingSessionWrapper, @ComponentImport ObjectMapperProvider objectMapperProvider) {
        this.journalService = (IndexJournalService)Preconditions.checkNotNull((Object)journalService);
        this.edgeIndexTaskFactory = (EdgeIndexTaskFactory)Preconditions.checkNotNull((Object)edgeIndexTaskFactory);
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate);
        this.nonFlushingSessionWrapper = (NonFlushingSessionWrapper)Preconditions.checkNotNull((Object)hibernateNonFlushingSessionWrapper);
        this.jsonMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapperProvider)).getObjectMapper();
    }

    @Override
    public void enqueue(IndexTaskType indexTaskType, ContentEntityObject target) {
        this.enqueue(indexTaskType, this.toJson(JournalEdgeIndexTaskQueue.buildIndexableEdge(target)));
    }

    @Override
    public void enqueue(IndexTaskType indexTaskType, Edge edge) {
        this.enqueue(indexTaskType, this.toJson(JournalEdgeIndexTaskQueue.buildIndexableEdge(edge)));
    }

    @Override
    public void enqueue(IndexTaskType indexTaskType, RebuildIndexTask.RebuildIndexParams rebuildIndexParams) {
        this.enqueue(indexTaskType, this.toJson(rebuildIndexParams));
    }

    @Override
    public long getSize() {
        return this.journalService.countEntries(JOURNAL_ID);
    }

    private static IndexableEdge buildIndexableEdge(ContentEntityObject target) {
        return new IndexableEdge(null, null, target != null ? target.getId() : 0L, null, null);
    }

    private static IndexableEdge buildIndexableEdge(Edge edge) {
        String edgeId = edge.getEdgeId() != null ? edge.getEdgeId().toString() : null;
        String userKey = edge.getUser() != null ? edge.getUser().getKey().getStringValue() : null;
        ContentEntityObject target = (ContentEntityObject)edge.getTarget();
        long targetId = target != null ? target.getId() : 0L;
        String edgeTypeKey = edge.getEdgeType() != null ? edge.getEdgeType().getKey() : null;
        return new IndexableEdge(edgeId, userKey, targetId, edge.getDate(), edgeTypeKey);
    }

    private String toJson(Object indexableParams) {
        try {
            return this.jsonMapper.writeValueAsString(indexableParams);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize object", e);
        }
    }

    private void enqueue(IndexTaskType indexTaskType, String message) {
        this.journalService.enqueue(new JournalEntry(JOURNAL_ID, indexTaskType.name(), message));
    }

    @Override
    public void processEntries(Effect<EdgeIndexTask> action) {
        this.transactionTemplate.execute(() -> {
            this.nonFlushingSessionWrapper.executeThenClearSessionWithoutCommitOrFlush(100, 1000, batchSize -> this.processEntriesInternal(action, (int)batchSize));
            return null;
        });
    }

    private Integer processEntriesInternal(Effect<EdgeIndexTask> action, int batchSize) {
        return (Integer)this.journalService.processNewEntries(JOURNAL_ID, batchSize, entries -> {
            int successCount = 0;
            for (JournalEntry entry : entries) {
                try {
                    this.toTask(entry).foreach(action);
                    ++successCount;
                }
                catch (RuntimeException e) {
                    log.warn("Failed to process edge index task for entry '{}'", (Object)entry, (Object)e);
                    return EntryProcessorResult.failure((Object)successCount, (long)entry.getId());
                }
            }
            return EntryProcessorResult.success((Object)successCount);
        });
    }

    private Maybe<EdgeIndexTask> toTask(JournalEntry entry) {
        try {
            if (IndexTaskType.valueOf(entry.getType()).equals((Object)IndexTaskType.REBUILD_INDEX)) {
                return Option.some((Object)this.edgeIndexTaskFactory.createRebuildIndexTask((RebuildIndexTask.RebuildIndexParams)this.jsonMapper.readValue(entry.getMessage(), RebuildIndexTask.RebuildIndexParams.class)));
            }
            IndexableEdge edge = (IndexableEdge)this.jsonMapper.readValue(entry.getMessage(), IndexableEdge.class);
            return switch (IndexTaskType.valueOf(entry.getType())) {
                case IndexTaskType.ADD_DOCUMENT -> this.edgeIndexTaskFactory.createAddDocumentTask(edge);
                case IndexTaskType.DELETE_DOCUMENT -> Option.some((Object)this.edgeIndexTaskFactory.createDeleteDocumentTask(edge));
                case IndexTaskType.DELETE_EDGE_BY_TARGET_ID_AND_USER -> Option.some((Object)this.edgeIndexTaskFactory.createDeleteEdgeByTargetIdAndUserTask(edge));
                case IndexTaskType.DELETE_EDGE_TARGETING_DOCUMENT -> Option.some((Object)this.edgeIndexTaskFactory.createDeleteEdgeTargetingDocumentTask(edge));
                case IndexTaskType.REINDEX_PERMISSIONS -> Option.some((Object)this.edgeIndexTaskFactory.createReIndexPermissionsTask(edge));
                default -> throw new IllegalArgumentException("Cannot handle entries with type '" + entry.getType() + "'");
            };
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse edge from message '" + entry.getMessage() + "'");
        }
    }
}

