/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.plugins.edgeindex.EdgeIndexFieldMappings;
import com.atlassian.confluence.plugins.edgeindex.EdgeTypeRepository;
import com.atlassian.confluence.plugins.edgeindex.ScoreConfig;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityEdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityObjectId;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeTargetId;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeType;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TopEdgeTargetCollector
implements Consumer<Map<String, String[]>> {
    static final int DECAY_THRESHOLD_SECONDS = 86400;
    private final long currentTimeSeconds;
    private final EdgeTypeRepository edgeTypeRepository;
    private final Set<UserKey> followeeKeys;
    private final ScoreConfig scoreConfig;
    private final Predicate<EdgeTargetInfo> acceptFilter;
    private final int maxTarget;
    private final PriorityQueue<EdgeTargetInfo> queue;
    private final Map<EdgeTargetId, EdgeTargetInfo> map;
    private ContentEntityEdgeTargetInfo lastTarget;

    public TopEdgeTargetCollector(EdgeTypeRepository edgeTypeRepository, Set<UserKey> followeeKeys, ScoreConfig scoreConfig, Predicate<EdgeTargetInfo> acceptFilter, int maxTarget, Date now) {
        Preconditions.checkArgument((maxTarget > 0 ? 1 : 0) != 0, (String)"non positive value: %s", (int)maxTarget);
        this.edgeTypeRepository = edgeTypeRepository;
        this.followeeKeys = followeeKeys;
        this.currentTimeSeconds = now.getTime() / 1000L;
        this.scoreConfig = scoreConfig;
        this.acceptFilter = acceptFilter;
        this.maxTarget = maxTarget;
        this.queue = new PriorityQueue(Math.min(maxTarget, 1024), (a, b) -> Float.compare(a.getScore(), b.getScore()));
        this.map = new HashMap<EdgeTargetId, EdgeTargetInfo>(this.queue.size());
        this.lastTarget = null;
    }

    public List<EdgeTargetInfo> getTopTargets() {
        if (this.lastTarget != null) {
            this.updateQueue(this.lastTarget);
        }
        LinkedList<EdgeTargetInfo> targets = new LinkedList<EdgeTargetInfo>();
        while (!this.queue.isEmpty()) {
            targets.addFirst(this.queue.poll());
        }
        return targets;
    }

    private float timeDecayFactor(long edgeAgeDays) {
        return (float)(1.0 / Math.pow(this.scoreConfig.getTimeDecayBase(), edgeAgeDays));
    }

    private int getRoundedDays(long timeSeconds) {
        return (int)Math.floor((float)timeSeconds / 86400.0f + 1.0f);
    }

    private void updateQueue(EdgeTargetInfo targetInfo) {
        this.queue.offer(targetInfo);
        this.map.put(targetInfo.getTargetId(), targetInfo);
        if (this.queue.size() > this.maxTarget) {
            EdgeTargetInfo removedItem = this.queue.poll();
            this.map.remove(removedItem.getTargetId());
        }
    }

    @Override
    public void accept(Map<String, String[]> fieldMap) {
        long edgeAgeSeconds;
        ContentEntityObjectId targetId = new ContentEntityObjectId(Long.parseLong(fieldMap.get(EdgeIndexFieldMappings.EDGE_TARGET_ID.getName())[0]));
        String targetType = fieldMap.get(EdgeIndexFieldMappings.EDGE_TARGET_TYPE.getName())[0];
        long edgeTimeSeconds = Long.parseLong(fieldMap.get(EdgeIndexFieldMappings.EDGE_DATE_FIELD.getName())[0]);
        String edgeTypeKey = fieldMap.get(EdgeIndexFieldMappings.EDGE_TYPE.getName())[0];
        String edgeUserKey = fieldMap.get(EdgeIndexFieldMappings.EDGE_USERKEY.getName())[0];
        if (!this.acceptFilter.test(new ContentEntityEdgeTargetInfo(targetType, targetId, 0.0f))) {
            return;
        }
        if (this.lastTarget == null) {
            this.lastTarget = new ContentEntityEdgeTargetInfo(targetType, targetId, 0.0f);
        }
        if (!this.lastTarget.getTargetId().equals(targetId)) {
            if (!this.map.containsKey(this.lastTarget.getTargetId())) {
                this.updateQueue(this.lastTarget);
            }
            this.lastTarget = !this.map.containsKey(targetId) ? new ContentEntityEdgeTargetInfo(targetType, targetId, 0.0f) : (ContentEntityEdgeTargetInfo)this.map.get(targetId);
        }
        float edgeScore = this.scoreConfig.getScore((EdgeType)this.edgeTypeRepository.getEdgeIndexTypeByKey(edgeTypeKey).get());
        if (this.followeeKeys.contains(new UserKey(edgeUserKey))) {
            edgeScore += this.scoreConfig.getFolloweeEdge();
        }
        if ((edgeAgeSeconds = this.currentTimeSeconds - edgeTimeSeconds) > 86400L) {
            int edgeAgeDays = this.getRoundedDays(edgeAgeSeconds);
            edgeScore *= this.timeDecayFactor(edgeAgeDays);
        }
        this.lastTarget.incrementScore(edgeScore);
    }
}

