/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.listener;

import com.atlassian.confluence.event.events.admin.ReIndexRequestEvent;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexBuilder;
import com.atlassian.event.api.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexListener {
    private static final Logger log = LoggerFactory.getLogger(ReindexListener.class);
    private final EdgeIndexBuilder edgeIndexBuilder;

    public ReindexListener(EdgeIndexBuilder edgeIndexBuilder) {
        this.edgeIndexBuilder = edgeIndexBuilder;
    }

    @EventListener
    public void onReindexRequested(ReIndexRequestEvent event) {
        if (event.getSpaceKeys().isEmpty()) {
            log.info("Rebuilding Edge index because a site reindex has been requested");
            this.edgeIndexBuilder.rebuild(EdgeIndexBuilder.EDGE_INDEX_REBUILD_DEFAULT_START_PERIOD, EdgeIndexBuilder.RebuildCondition.FORCE);
        }
    }
}

