/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.persistence.JpaQueryFactory;
import com.atlassian.confluence.plugins.edgeindex.rest.ContentEntityHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.persistence.Query;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ContentEntityHelper.class})
public class HibernateContentEntityHelper
implements ContentEntityHelper {
    private final JpaQueryFactory jpaQueryFactory;

    @Autowired
    public HibernateContentEntityHelper(@ComponentImport JpaQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    @Override
    public List<ContentEntityObject> getContentEntities(List<Long> contentIds) {
        if (contentIds == null || contentIds.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ContentEntityObject> orderedContentEntities = new LinkedList<ContentEntityObject>();
        Query query = this.jpaQueryFactory.createQuery("select ceo from ContentEntityObject ceo where ceo.id in (:contentIds)");
        query.setParameter("contentIds", contentIds);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        List queryResults = query.getResultList();
        HashMap<Long, ContentEntityObject> idToEntityMap = new HashMap<Long, ContentEntityObject>();
        for (ContentEntityObject queryResult : queryResults) {
            idToEntityMap.put(queryResult.getId(), queryResult);
        }
        for (Long contentId : contentIds) {
            ContentEntityObject contentEntity = (ContentEntityObject)idToEntityMap.get(contentId);
            if (contentEntity == null) continue;
            orderedContentEntities.add(contentEntity);
        }
        return orderedContentEntities;
    }

    @Override
    public Map<Long, Integer> getCommentCounts(List<Long> contentIds) {
        if (contentIds == null || contentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Query query = this.jpaQueryFactory.createQuery("select ceo.id, count(comments) from ContentEntityObject as ceo left join ceo.comments as comments where ceo.id in (:contentIds) group by ceo.id");
        query.setParameter("contentIds", contentIds);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        for (Object o : query.getResultList()) {
            Object[] data = (Object[])o;
            result.put((Long)data[0], ((Number)data[1]).intValue());
        }
        return result;
    }

    @Override
    public Map<Long, Integer> getNestedCommentCounts(List<Long> commentIds) {
        if (commentIds == null || commentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Query query = this.jpaQueryFactory.createQuery("select comment.id, count(comments) from Comment as comment left join comment.children as comments where comment.id in (:commentIds) group by comment.id");
        query.setParameter("commentIds", commentIds);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        for (Object o : query.getResultList()) {
            Object[] data = (Object[])o;
            result.put((Long)data[0], ((Number)data[1]).intValue());
        }
        return result;
    }
}

