/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.servlet;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexBuilder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.joda.time.Period;
import org.springframework.beans.factory.annotation.Autowired;

@AnonymousSiteAccess
public class BuildEdgeIndexServlet
extends HttpServlet {
    private final PermissionManager permissionManager;
    private final EdgeIndexBuilder edgeIndexBuilder;
    private final XsrfTokenService xsrfTokenService;

    @Autowired
    public BuildEdgeIndexServlet(@ComponentImport PermissionManager permissionManager, EdgeIndexBuilder edgeIndexBuilder, @ComponentImport XsrfTokenService xsrfTokenService) {
        this.permissionManager = permissionManager;
        this.edgeIndexBuilder = edgeIndexBuilder;
        this.xsrfTokenService = xsrfTokenService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            resp.sendError(403, "Insufficient privileges.");
            return;
        }
        Object responseBody = "";
        responseBody = (String)responseBody + "<form action=\"" + req.getContextPath() + "/plugins/servlet/edge-index/build\" method=\"post\">";
        responseBody = (String)responseBody + "<input type=\"hidden\" name=\"atl_token\" value=\"" + this.xsrfTokenService.generateValidToken(req) + "\">";
        responseBody = (String)responseBody + "<input type='text' name='weeks' value='2'>";
        responseBody = (String)responseBody + "<input type=\"submit\" value=\"Build edge index\">";
        responseBody = (String)responseBody + "</form>";
        resp.getWriter().append((CharSequence)responseBody);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            resp.sendError(403, "Insufficient privileges.");
            return;
        }
        try {
            this.edgeIndexBuilder.rebuild(BuildEdgeIndexServlet.getRebuildPeriod(req), EdgeIndexBuilder.RebuildCondition.FORCE);
            resp.getWriter().append("Build index completed successfully");
        }
        catch (RuntimeException e) {
            resp.sendError(500);
            throw e;
        }
    }

    private static Period getRebuildPeriod(HttpServletRequest req) {
        String weeksParam = req.getParameter("weeks");
        if (!Strings.isNullOrEmpty((String)weeksParam)) {
            return Period.weeks((int)Integer.parseInt(weeksParam));
        }
        return EdgeIndexBuilder.EDGE_INDEX_REBUILD_DEFAULT_START_PERIOD;
    }
}

