/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.tasks;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexFieldMappings;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexTask;
import com.atlassian.confluence.plugins.edgeindex.EdgeSearchIndexAccessor;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.LongFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.search.v2.AtlassianDocument;
import com.atlassian.confluence.search.v2.ContentPermissionCalculator;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.ScannedDocument;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.FieldExistsQuery;
import com.atlassian.confluence.search.v2.query.LongRangeQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.search.v2.query.TermSetQuery;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ReIndexPermissionsIndexTask
implements EdgeIndexTask {
    private static final Logger log = LoggerFactory.getLogger(ReIndexPermissionsIndexTask.class);
    private final String contentId;
    private final ContentEntityManager contentEntityManager;
    private final TransactionTemplate txTemplate;
    private final EdgeSearchIndexAccessor edgeSearchIndexAccessor;
    private final ContentPermissionCalculator contentPermissionCalculator;

    public ReIndexPermissionsIndexTask(String contentId, ContentEntityManager contentEntityManager, TransactionTemplate txTemplate, EdgeSearchIndexAccessor edgeSearchIndexAccessor, ContentPermissionCalculator contentPermissionCalculator) {
        this.contentId = contentId;
        this.contentEntityManager = contentEntityManager;
        this.txTemplate = txTemplate;
        this.edgeSearchIndexAccessor = edgeSearchIndexAccessor;
        this.contentPermissionCalculator = contentPermissionCalculator;
    }

    public String getDescription() {
        return String.format("Reindex permissions task on content ID '%s'.", this.contentId);
    }

    public SearchIndex getSearchIndex() {
        return SearchIndex.CUSTOM;
    }

    public void perform(SearchIndexWriter searchIndexWriter) {
        this.txTemplate.execute(() -> {
            try {
                this.doReindex(searchIndexWriter);
                return null;
            }
            catch (IOException e) {
                return Throwables.propagate((Throwable)e);
            }
        });
    }

    private void doReindex(SearchIndexWriter writer) throws IOException {
        log.debug("Beginning permissions re-indexing process for content {}", (Object)this.contentId);
        ContentEntityObject contentEntity = this.contentEntityManager.getById(Long.parseLong(this.contentId));
        if (contentEntity != null) {
            try {
                this.doReindex(writer, contentEntity);
            }
            catch (InvalidSearchException e) {
                log.error("Could not update the permissions field of the edge index for content {}", (Object)this.contentId, (Object)e);
            }
        } else {
            log.debug("Cannot reindex content {} - no such ContentEntityObject found", (Object)this.contentId);
        }
    }

    private void doReindex(SearchIndexWriter writer, ContentEntityObject contentEntity) throws InvalidSearchException {
        HashSet<String> edgeEntityIds = new HashSet<String>();
        edgeEntityIds.add(this.contentId);
        List comments = contentEntity.getComments();
        for (Comment comment : comments) {
            if (CollectionUtils.isEmpty((Collection)comment.getChildren())) continue;
            String commentId = comment.getIdAsString();
            edgeEntityIds.add(commentId);
        }
        int numDocumentsReindexed = this.findAndReindexDocuments(edgeEntityIds, writer);
        log.trace("Found and updated {} edge index documents for content {}", (Object)numDocumentsReindexed, (Object)this.contentId);
        log.debug("Completed permissions re-indexing for content {}", (Object)this.contentId);
    }

    private int findAndReindexDocuments(Set<String> edgeEntityIds, SearchIndexWriter writer) {
        AtomicInteger numDocumentsReIndexed;
        TermSetQuery edgesRelatedToTargetQuery = new TermSetQuery(EdgeIndexFieldMappings.EDGE_TARGET_ID.getName(), edgeEntityIds);
        long total = this.edgeSearchIndexAccessor.scan((SearchQuery)edgesRelatedToTargetQuery, null, arg_0 -> this.lambda$findAndReindexDocuments$1(writer, numDocumentsReIndexed = new AtomicInteger(0), arg_0), 0.0f);
        if (total != (long)numDocumentsReIndexed.get()) {
            log.warn("Total {} edge index docs scanned but only {} re-built. Please check the ERROR messages in the log for more details.", (Object)total, (Object)numDocumentsReIndexed.get());
        }
        return numDocumentsReIndexed.get();
    }

    private AtlassianDocument getDocument(ScannedDocument scannedDocument) {
        AtlassianDocument document = new AtlassianDocument();
        String edgeTargetId = scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_TARGET_ID.getName());
        document.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_USERKEY.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_USERKEY.getName()), FieldDescriptor.Store.YES));
        document.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_TARGET_ID.getName(), edgeTargetId, FieldDescriptor.Store.YES));
        document.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_TYPE.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_TYPE.getName()), FieldDescriptor.Store.YES));
        if (scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_ID.getName()) != null) {
            document.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_ID.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_ID.getName()), FieldDescriptor.Store.YES));
        }
        document.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_TARGET_AUTHOR.getName(), (String)StringUtils.defaultIfBlank((CharSequence)scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_TARGET_AUTHOR.getName()), (CharSequence)""), FieldDescriptor.Store.YES));
        document.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_TARGET_TYPE.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_TARGET_TYPE.getName()), FieldDescriptor.Store.YES));
        if (StringUtils.isNotBlank((CharSequence)scannedDocument.getFieldValue(SearchFieldMappings.SPACE_KEY.getName()))) {
            document.addField((FieldDescriptor)new StringFieldDescriptor(SearchFieldMappings.SPACE_KEY.getName(), (String)StringUtils.defaultIfBlank((CharSequence)scannedDocument.getFieldValue(SearchFieldMappings.SPACE_KEY.getName()), (CharSequence)""), FieldDescriptor.Store.YES));
        } else {
            document.addField((FieldDescriptor)new StringFieldDescriptor(SearchFieldMappings.IN_SPACE.getName(), "false", FieldDescriptor.Store.NO));
        }
        document.addField((FieldDescriptor)new LongFieldDescriptor(EdgeIndexFieldMappings.EDGE_DATE_FIELD.getName(), Long.parseLong(scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_DATE_FIELD.getName())), FieldDescriptor.Store.YES));
        ContentEntityObject target = this.contentEntityManager.getById(Long.parseLong(edgeTargetId));
        Collection permissions = this.contentPermissionCalculator.calculate(target);
        if (!permissions.isEmpty()) {
            document.addFields(SearchFieldMappings.PERMISSION_SETS.createFields(permissions));
        }
        return document;
    }

    private /* synthetic */ void lambda$findAndReindexDocuments$1(SearchIndexWriter writer, AtomicInteger numDocumentsReIndexed, ScannedDocument scannedDocument) {
        AtlassianDocument doc = this.getDocument(scannedDocument);
        String edgeId = scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_ID.getName());
        try {
            if (!StringUtils.isEmpty((CharSequence)edgeId)) {
                writer.delete((SearchQuery)new TermQuery(EdgeIndexFieldMappings.EDGE_ID.getName(), edgeId));
            } else {
                long date = Long.parseLong(scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_DATE_FIELD.getName()));
                writer.delete((SearchQuery)new BooleanQuery.Builder().addMust((Object)new TermQuery(EdgeIndexFieldMappings.EDGE_USERKEY.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_USERKEY.getName()))).addMust((Object)new TermQuery(EdgeIndexFieldMappings.EDGE_TARGET_TYPE.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_TARGET_TYPE.getName()))).addMust((Object)new TermQuery(EdgeIndexFieldMappings.EDGE_TARGET_ID.getName(), scannedDocument.getFieldValue(EdgeIndexFieldMappings.EDGE_TARGET_ID.getName()))).addMust((Object)FieldExistsQuery.fieldNotExistsQuery((String)EdgeIndexFieldMappings.EDGE_ID.getName())).addMust((Object)new LongRangeQuery(EdgeIndexFieldMappings.EDGE_DATE_FIELD.getName(), new Range((Object)date, (Object)date, true, true))).build());
                doc.addField((FieldDescriptor)new StringFieldDescriptor(EdgeIndexFieldMappings.EDGE_ID.getName(), UUID.randomUUID().toString(), FieldDescriptor.Store.YES));
            }
            writer.add(doc);
            numDocumentsReIndexed.getAndIncrement();
        }
        catch (IOException e) {
            log.error("Error occurred while reindexing edge with ID {}", (Object)edgeId, (Object)e);
        }
    }
}

