/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.tasks;

import com.atlassian.confluence.plugins.edgeindex.EdgeIndexTask;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexTaskFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeReindexer;
import com.atlassian.confluence.plugins.edgeindex.EdgeSearchIndexAccessor;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.search.v2.SearchIndexWriter;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildIndexTask
implements EdgeIndexTask {
    private static final Logger LOG = LoggerFactory.getLogger(RebuildIndexTask.class);
    private final EdgeIndexTaskFactory edgeIndexTaskFactory;
    private final EdgeReindexer edgeReindexer;
    private final EdgeSearchIndexAccessor edgeSearchIndexAccessor;
    private final RebuildIndexParams rebuildIndexParams;

    public RebuildIndexTask(EdgeIndexTaskFactory edgeIndexTaskFactory, EdgeReindexer edgeReindexer, EdgeSearchIndexAccessor edgeSearchIndexAccessor, RebuildIndexParams rebuildIndexParams) {
        this.edgeIndexTaskFactory = Objects.requireNonNull(edgeIndexTaskFactory);
        this.edgeReindexer = Objects.requireNonNull(edgeReindexer);
        this.edgeSearchIndexAccessor = Objects.requireNonNull(edgeSearchIndexAccessor);
        this.rebuildIndexParams = Objects.requireNonNull(rebuildIndexParams);
    }

    public SearchIndex getSearchIndex() {
        return SearchIndex.CUSTOM;
    }

    public void perform(SearchIndexWriter searchIndexWriter) throws IOException {
        StopWatch stopWatch = StopWatch.createStarted();
        LOG.debug("Rebuilding edge index");
        this.edgeSearchIndexAccessor.withBatchUpdate(() -> this.edgeReindexer.reindex(Instant.ofEpochMilli((long)this.rebuildIndexParams.getStartDate()).toDate(), this.rebuildIndexParams.getUsername(), this::indexAction));
        LOG.debug("Rebuild complete in {}ms", (Object)stopWatch.getTime(TimeUnit.MILLISECONDS));
        stopWatch.stop();
    }

    private void indexAction(Edge edge) {
        EdgeIndexTask task = this.edgeIndexTaskFactory.createAddDocumentTask(edge);
        this.edgeSearchIndexAccessor.execute(arg_0 -> ((EdgeIndexTask)task).perform(arg_0));
    }

    public String getDescription() {
        return String.format("Rebuild edge index from %s", this.rebuildIndexParams.getStartDate().toString());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RebuildIndexParams {
        private final String username;
        private final Long startDate;

        public RebuildIndexParams(@JsonProperty(value="startDate") Long startDate, @JsonProperty(value="username") String username) {
            this.startDate = Objects.requireNonNull(startDate);
            this.username = username;
        }

        public Long getStartDate() {
            return this.startDate;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

