/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3;

import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.PrivateCalendarUrlManager;
import com.atlassian.confluence.extra.calendar3.events.SubCalendarSubscribed;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.PairType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.user.User;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPrivateCalendarUrlManager
implements PrivateCalendarUrlManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPrivateCalendarUrlManager.class);
    public static final String USER_MAP_NAMESPACE = DigestUtils.sha1Hex((String)DefaultPrivateCalendarUrlManager.class.getName()) + ".userMap";
    public static final String TOKEN_MAP_NAMESPACE = DigestUtils.sha1Hex((String)DefaultPrivateCalendarUrlManager.class.getName()) + ".tokenMap";
    private final UserAccessor userAccessor;
    private final CalendarManager calendarManager;
    private final EventPublisher eventPublisher;
    private final ExtendedPluginSettings userMapSettings;
    private final ExtendedPluginSettings tokenMapSettings;
    private final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();

    @Autowired
    public DefaultPrivateCalendarUrlManager(@ComponentImport ExtendedPluginSettingsFactory pluginSettingsFactory, @ComponentImport UserAccessor userAccessor, CalendarManager calendarManager, @ComponentImport EventPublisher eventPublisher) {
        this.userAccessor = userAccessor;
        this.calendarManager = calendarManager;
        this.eventPublisher = eventPublisher;
        this.userMapSettings = pluginSettingsFactory.createSettingsForKey(USER_MAP_NAMESPACE);
        this.tokenMapSettings = pluginSettingsFactory.createSettingsForKey(TOKEN_MAP_NAMESPACE);
    }

    @Override
    public synchronized String getTokenFor(ConfluenceUser user, String calendarId) {
        if (!this.calendarManager.hasSubCalendar(calendarId)) {
            return null;
        }
        LinkedList<String> tokens = (LinkedList<String>)this.userMapSettings.get(user.getKey().toString());
        if (tokens == null) {
            tokens = new LinkedList<String>();
        }
        for (String token : tokens) {
            PairType calendarIdUserPair = this.getCalendarIdUserPairType(token);
            if (null == calendarIdUserPair || !StringUtils.equals((CharSequence)((String)((Object)calendarIdUserPair.getKey())), (CharSequence)calendarId)) continue;
            return token;
        }
        String newToken = DefaultSecureTokenGenerator.getInstance().generateToken();
        tokens.add(newToken);
        String userId = user.getKey().toString();
        this.tokenMapSettings.put(newToken, (Object)this.mapper.serialize((Object)new PairType((Serializable)((Object)calendarId), (Serializable)((Object)userId))));
        this.userMapSettings.put(userId, tokens);
        this.eventPublisher.publish((Object)new SubCalendarSubscribed(this, user));
        return newToken;
    }

    @Override
    public ConfluenceUser getUserFor(String token) {
        PairType calendarIdUserPair = this.getCalendarIdUserPairType(token);
        if (calendarIdUserPair == null) {
            return null;
        }
        return this.userAccessor.getUserByKey(new UserKey((String)((Object)calendarIdUserPair.getValue())));
    }

    @Override
    public String getCalendarId(String token) {
        PairType calendarIdUserPair = this.getCalendarIdUserPairType(token);
        if (calendarIdUserPair == null) {
            return null;
        }
        String userId = (String)((Object)calendarIdUserPair.getValue());
        if (this.isUserDeactivated(userId)) {
            LOG.warn("Attempt to access calendar subscription for deactivated user: {}", (Object)userId);
            return null;
        }
        return (String)((Object)calendarIdUserPair.getKey());
    }

    private boolean isUserDeactivated(String userId) {
        return this.userAccessor.isDeactivated((User)this.userAccessor.getUserByKey(new UserKey(userId)));
    }

    private PairType getCalendarIdUserPairType(String token) {
        String pairJson = (String)this.tokenMapSettings.get(token);
        return (PairType)this.mapper.deserializeOrNull(pairJson, PairType.class);
    }

    @Override
    public synchronized void resetPrivateUrlsFor(ConfluenceUser user, String subCalendarId) {
        List tokens = (List)this.userMapSettings.get(user.getKey().toString());
        if (tokens != null && !tokens.isEmpty()) {
            Collection tokensToRemove = Collections2.filter((Collection)tokens, token -> {
                PairType calendarIdUserPair = this.getCalendarIdUserPairType((String)token);
                return null != calendarIdUserPair && StringUtils.equals((CharSequence)((String)((Object)calendarIdUserPair.getKey())), (CharSequence)subCalendarId);
            });
            for (String tokenToRemove : tokensToRemove) {
                this.tokenMapSettings.remove(tokenToRemove);
            }
            if (new HashSet(tokens).equals(new HashSet(tokensToRemove))) {
                this.userMapSettings.remove(user.getKey().toString());
            }
        }
    }

    @Override
    public synchronized void resetAllPrivateUrls() {
        for (String token : this.tokenMapSettings.getKeys()) {
            this.tokenMapSettings.remove(token);
        }
        for (String user : this.userMapSettings.getKeys()) {
            this.userMapSettings.remove(user);
        }
    }
}

