/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3;

import com.atlassian.confluence.extra.calendar3.SubCalendarColorRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.stereotype.Component;

@Component
public class DefaultSubCalendarColorRegistry
implements SubCalendarColorRegistry {
    private static final String COLOUR_SCHEME_VERY_LIGHT_SUFFIX = "-very-light";
    private final Map<String, String> colorMap = new LinkedHashMap<String, String>(){
        {
            this.put("subcalendar-gray", "var(--ds-background-accent-gray-subtler, #DCDFE4)");
            this.put("subcalendar-blue", "var(--ds-background-accent-blue-subtler, #CCE0FF)");
            this.put("subcalendar-green2", "var(--ds-background-accent-teal-subtler, #C6EDFB)");
            this.put("subcalendar-green4", "var(--ds-background-accent-green-subtler, #BAF3DB)");
            this.put("subcalendar-yellow", "var(--ds-background-accent-yellow-subtler, #F8E6A0)");
            this.put("subcalendar-pink", "var(--ds-background-accent-red-subtler, #FFD5D2)");
            this.put("subcalendar-purple", "var(--ds-background-accent-purple-subtler, #DFD8FD)");
            this.put("subcalendar-gray2", "var(--ds-background-accent-gray-subtle, #8590A2)");
            this.put("subcalendar-blue2", "var(--ds-background-accent-blue-subtle, #579DFF)");
            this.put("subcalendar-turquoise", "var(--ds-background-accent-teal-subtle, #6CC3E0)");
            this.put("subcalendar-green3", "var(--ds-background-accent-green-subtle, #4BCE97)");
            this.put("subcalendar-orange2", "var(--ds-background-accent-yellow-subtle, #F5CD47)");
            this.put("subcalendar-red", "var(--ds-background-accent-red-subtle, #F87168)");
            this.put("subcalendar-purple2", "var(--ds-background-accent-purple-subtle, #9F8FEF)");
            this.put("subcalendar-green5", "var(--ds-background-accent-gray-bolder, #626F86)");
            this.put("subcalendar-purple3", "var(--ds-background-accent-blue-bolder, #0C66E4)");
            this.put("subcalendar-green6", "var(--ds-background-accent-teal-bolder, #227D9B)");
            this.put("subcalendar-green", "var(--ds-background-accent-green-bolder, #1F845A)");
            this.put("subcalendar-bronze", "var(--ds-background-accent-yellow-bolder, #946F00)");
            this.put("subcalendar-orange", "var(--ds-background-accent-red-bolder, #C9372C)");
            this.put("subcalendar-purple4", "var(--ds-background-accent-purple-bolder, #6E5DC6)");
        }
    };
    private final Map<String, String> textColorMap = Map.ofEntries(Map.entry("subcalendar-gray", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-blue", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-green2", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-green4", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-yellow", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-pink", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-purple", "var(--ds-text, #172B4D)"), Map.entry("subcalendar-gray2", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-blue2", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-turquoise", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-green3", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-orange2", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-red", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-purple2", "var(--ds-text-accent-gray-bolder, #091E42)"), Map.entry("subcalendar-orange", "var(--ds-text-inverse, #FFFFFF)"), Map.entry("subcalendar-purple3", "var(--ds-text-inverse, #FFFFFF)"), Map.entry("subcalendar-green6", "var(--ds-text-inverse, #FFFFFF)"), Map.entry("subcalendar-green", "var(--ds-text-inverse, #FFFFFF)"), Map.entry("subcalendar-bronze", "var(--ds-text-inverse, #FFFFFF)"), Map.entry("subcalendar-green5", "var(--ds-text-inverse, #FFFFFF)"), Map.entry("subcalendar-purple4", "var(--ds-text-inverse, #FFFFFF)"));
    private final int hashCodeCache = this.computeHashCode();

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass() && obj.hashCode() != this.hashCode()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DefaultSubCalendarColorRegistry rhs = (DefaultSubCalendarColorRegistry)obj;
        return new EqualsBuilder().append(this.colorMap, rhs.colorMap).append(this.textColorMap, rhs.textColorMap).isEquals();
    }

    public int hashCode() {
        return this.getHashCodeCache();
    }

    @VisibleForTesting
    int getHashCodeCache() {
        return this.hashCodeCache;
    }

    @VisibleForTesting
    int computeHashCode() {
        return new HashCodeBuilder().append(this.colorMap).append(this.textColorMap).build();
    }

    @Override
    public Set<String> getColorClasses() {
        return this.colorMap.keySet();
    }

    @Override
    public String getColorHex(String colorClass) {
        return this.colorMap.get(colorClass);
    }

    @Override
    public String getLightenedColorHex(String colorClass) {
        return this.textColorMap.get(colorClass);
    }

    @Override
    public String getEvenMoreLightenedColorHex(String colorClass) {
        return this.textColorMap.get(colorClass);
    }

    @Override
    public String getEventMoreLightenedColourScheme(String colourClass) {
        return colourClass + COLOUR_SCHEME_VERY_LIGHT_SUFFIX;
    }

    @Override
    public boolean isEventMoreLightenedColourScheme(String evenMoreLightenedColourScheme) {
        return StringUtils.endsWith((CharSequence)evenMoreLightenedColourScheme, (CharSequence)COLOUR_SCHEME_VERY_LIGHT_SUFFIX);
    }

    @Override
    public String getRandomColourClass(String ... excludeColourClasses) {
        String randomColourClass;
        ArrayList colourClasses = Lists.newArrayList(this.getColorClasses());
        while (ArrayUtils.contains((Object[])excludeColourClasses, (Object)(randomColourClass = (String)colourClasses.get(ThreadLocalRandom.current().nextInt(colourClasses.size()))))) {
        }
        return randomColourClass;
    }
}

