/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3;

import com.atlassian.confluence.extra.calendar3.util.DefaultBuildInformationManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class HelpTipManager {
    private final PluginSettings pluginSettings;
    @VisibleForTesting
    public static final String helpTipNamespace = DefaultBuildInformationManager.getBuildInformationPluginSettingsNamespace(HelpTipManager.class.getName());

    @Autowired
    public HelpTipManager(@ComponentImport @Qualifier(value="pluginSettingsFactory") PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(helpTipNamespace);
    }

    public void dismissTip(User user, String id) {
        String tipId = this.getTipId(id);
        Set<String> dismissedHelpTipIds = this.getDismissedHelpTipIds(user);
        dismissedHelpTipIds.add(tipId);
        this.pluginSettings.put(user.getName(), dismissedHelpTipIds);
    }

    public void undismissTip(User user, String id) {
        String tipId = this.getTipId(id);
        Set<String> dismissedHelpTipIds = this.getDismissedHelpTipIds(user);
        dismissedHelpTipIds.remove(tipId);
        this.pluginSettings.put(user.getName(), dismissedHelpTipIds);
    }

    public Collection<String> getDismissedTips(User user) {
        return this.getDismissedHelpTipIds(user);
    }

    private String getTipId(String id) {
        return id;
    }

    private Set<String> getDismissedHelpTipIds(User user) {
        Set dismissedHelpTipIds = (Set)this.pluginSettings.get(user.getName());
        if (dismissedHelpTipIds == null) {
            return new HashSet<String>();
        }
        return dismissedHelpTipIds;
    }
}

