/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.caldav;

import com.atlassian.confluence.extra.calendar3.caldav.node.CalendarCalDAVEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.bedework.caldav.server.CalDAVEvent;
import org.bedework.caldav.server.Organizer;
import org.bedework.caldav.server.SysiIcalendar;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.webdav.servlet.shared.WdEntity;
import org.bedework.webdav.servlet.shared.WebdavException;

public final class CalendarSysiIcalendar
extends SysiIcalendar {
    private final PropertyList<Property> calendarProperties;
    private final Collection<CalendarCalDAVEvent> events;
    private final List<CalendarCalDAVEvent> iteratingList;

    public CalendarSysiIcalendar(PropertyList<Property> calendarProperties, Collection<CalendarCalDAVEvent> events) {
        this.calendarProperties = calendarProperties;
        this.events = events;
        this.iteratingList = this.calculateIteratingList();
    }

    private List<CalendarCalDAVEvent> calculateIteratingList() {
        Map<String, List<CalendarCalDAVEvent>> groupByUid = this.events.stream().collect(Collectors.groupingBy(event -> event.getSubCalendarEvent().getUid()));
        return groupByUid.entrySet().stream().flatMap(entry -> {
            List sameEvents = (List)entry.getValue();
            return sameEvents.size() == 1 ? sameEvents.stream() : sameEvents.stream().filter(calendarCalDAVEvent -> StringUtils.isNotEmpty((CharSequence)calendarCalDAVEvent.getSubCalendarEvent().getRecurrenceId()));
        }).collect(Collectors.toList());
    }

    public String getProdid() {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        throw new UnsupportedOperationException();
    }

    public String getCalscale() {
        throw new UnsupportedOperationException();
    }

    public String getMethod() {
        Property method = (Property)this.calendarProperties.getProperty("METHOD");
        return method != null ? method.getValue() : null;
    }

    public Collection<TimeZone> getTimeZones() {
        throw new UnsupportedOperationException();
    }

    public Collection<Object> getComponents() {
        throw new UnsupportedOperationException();
    }

    public IcalDefs.IcalComponentType getComponentType() {
        throw new UnsupportedOperationException();
    }

    public int getMethodType() {
        throw new UnsupportedOperationException();
    }

    public int getMethodType(String val) {
        throw new UnsupportedOperationException();
    }

    public String getMethodName(int mt) {
        throw new UnsupportedOperationException();
    }

    public Organizer getOrganizer() {
        throw new UnsupportedOperationException();
    }

    public CalDAVEvent getEvent() throws WebdavException {
        throw new UnsupportedOperationException();
    }

    public Iterator<WdEntity<?>> iterator() {
        return this;
    }

    public CalDAVEvent<?> getOnlyEvent() {
        if (this.events.size() != 1) {
            throw new UnsupportedOperationException("getOnlyEvent() requires exactly one event, but found " + this.events.size());
        }
        return this.events.iterator().next();
    }

    public void assertNoMethod(String operation) {
        if (operation != null && !"PUT".equalsIgnoreCase(operation)) {
            throw new UnsupportedOperationException("Operation '" + operation + "' is not supported.");
        }
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public boolean validItipMethodType() {
        throw new UnsupportedOperationException();
    }

    public boolean requestMethodType() {
        throw new UnsupportedOperationException();
    }

    public boolean replyMethodType() {
        throw new UnsupportedOperationException();
    }

    public boolean itipRequestMethodType(int mt) {
        throw new UnsupportedOperationException();
    }

    public boolean itipReplyMethodType(int mt) {
        throw new UnsupportedOperationException();
    }

    public boolean validItipMethodType(int val) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.iteratingList.iterator().hasNext();
    }

    public WdEntity next() {
        return (WdEntity)this.iteratingList.iterator().next();
    }
}

