/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.caldav.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@UnrestrictedAccess
public class CalDavAuthenticationFilter
extends HttpFilter {
    private final ApplicationProperties applicationProperties;

    public CalDavAuthenticationFilter(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)new BasicWWWWAuthenticateAddingResponse(response, this.applicationProperties));
    }

    private static final class BasicWWWWAuthenticateAddingResponse
    extends HttpServletResponseWrapper {
        private final ApplicationProperties applicationProperties;

        BasicWWWWAuthenticateAddingResponse(HttpServletResponse response, ApplicationProperties applicationProperties) {
            super(response);
            this.applicationProperties = applicationProperties;
        }

        public void sendError(int error) throws IOException {
            if (error == 401) {
                this.addBasicAuthenticateHeader();
            }
            super.sendError(error);
        }

        public void sendError(int error, String msg) throws IOException {
            if (error == 401) {
                this.addBasicAuthenticateHeader();
            }
            super.sendError(error, msg);
        }

        private void addBasicAuthenticateHeader() {
            String realm = URLEncoder.encode(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), StandardCharsets.UTF_8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            super.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", realm));
        }
    }
}

