/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.caldav.node;

import com.atlassian.confluence.extra.calendar3.caldav.CalendarAccessPrincipal;
import com.atlassian.confluence.extra.calendar3.caldav.node.freebusy.CalDavNodeFreeBusySupport;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.bedework.caldav.server.CalDAVCollection;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.webdav.servlet.shared.WebdavException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class AbstractCalDAVCollection<TYPE extends CalDAVCollection<?>>
extends CalDAVCollection<TYPE> {
    private static final String VEVENT_COMPONENT = "VEVENT";
    private int calType;
    private final CalDavNodeFreeBusySupport freeBusySupport;

    AbstractCalDAVCollection(String path, CalendarAccessPrincipal owner, int calType, CalDavNodeFreeBusySupport freeBusySupport) throws WebdavException {
        this.setPath(path);
        this.setOwner(owner);
        this.setCalType(calType);
        this.setLastmod(DateTimeUtil.isoDateTimeUTC((Date)DateTime.now((DateTimeZone)DateTimeZone.UTC).toDate()));
        this.freeBusySupport = freeBusySupport;
    }

    public final boolean freebusyAllowed() throws WebdavException {
        return this.freeBusySupport.freeBusyAllowed();
    }

    public final void setAffectsFreeBusy(boolean value) throws WebdavException {
        this.freeBusySupport.setAffectsFreeBusy(value);
    }

    public final boolean getAffectsFreeBusy() throws WebdavException {
        return this.freeBusySupport.getAffectsFreeBusy();
    }

    public boolean getCanShare() {
        throw new UnsupportedOperationException();
    }

    public boolean getCanPublish() {
        throw new UnsupportedOperationException();
    }

    public boolean isAlias() {
        throw new UnsupportedOperationException();
    }

    public String getAliasUri() {
        throw new UnsupportedOperationException();
    }

    public void setProperty(QName name, String value) {
    }

    public String getProperty(QName name) {
        throw new UnsupportedOperationException();
    }

    public String getEtag() throws WebdavException {
        throw new UnsupportedOperationException();
    }

    public String getPreviousEtag() {
        throw new UnsupportedOperationException();
    }

    public TYPE resolveAlias(boolean resolveSubAlias) {
        throw new UnsupportedOperationException();
    }

    public final void setCalType(int value) {
        this.calType = value;
    }

    public int getCalType() {
        return this.calType;
    }

    public boolean getDeleted() {
        throw new UnsupportedOperationException();
    }

    public boolean entitiesAllowed() {
        throw new UnsupportedOperationException();
    }

    public void setTimezone(String value) {
    }

    public String getTimezone() {
        throw new UnsupportedOperationException();
    }

    public void setColor(String value) {
        throw new UnsupportedOperationException();
    }

    public String getColor() {
        throw new UnsupportedOperationException();
    }

    public void setSupportedComponents(List<String> value) {
        throw new UnsupportedOperationException();
    }

    public List<String> getSupportedComponents() {
        return Collections.singletonList(VEVENT_COMPONENT);
    }

    public List<String> getVpollSupportedComponents() {
        throw new UnsupportedOperationException();
    }

    public void setAliasUri(String val) {
        throw new UnsupportedOperationException();
    }

    public void setRemoteId(String val) {
        throw new UnsupportedOperationException();
    }

    public String getRemoteId() {
        throw new UnsupportedOperationException();
    }

    public void setRemotePw(String val) {
        throw new UnsupportedOperationException();
    }

    public String getRemotePw() {
        throw new UnsupportedOperationException();
    }

    public void setRefreshRate(int i) {
    }

    public int getRefreshRate() {
        return 0;
    }

    public void setSynchDeleteSuppressed(boolean b) {
    }

    public boolean getSynchDeleteSuppressed() {
        return false;
    }
}

