/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore;

import com.atlassian.confluence.extra.calendar3.calendarstore.BaseCacheableCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.calendarstore.DataStoreCommonPropertyAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.DelegatableCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.calendarstore.RefreshableCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.calendarstore.event.transformers.SubCalendarEventTransformerFactory;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.util.XConfluencePersonPropertyToAttendeePropertyTransformer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.transform.Transformer;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPeopleHandlingSubCalendarDataStore<T extends PersistedSubCalendar>
extends BaseCacheableCalendarDataStore<T>
implements RefreshableCalendarDataStore<T>,
DelegatableCalendarDataStore<T> {
    public AbstractPeopleHandlingSubCalendarDataStore(DataStoreCommonPropertyAccessor dataStoreCommonPropertyAccessor) {
        super(dataStoreCommonPropertyAccessor);
    }

    @Override
    public boolean handles(SubCalendar subCalendar) {
        return StringUtils.equals((CharSequence)this.getType(), (CharSequence)subCalendar.getType());
    }

    @Override
    public void validate(SubCalendar subCalendar, Map<String, List<String>> fieldErrors) {
        super.validate(subCalendar, fieldErrors);
        if (StringUtils.isBlank((CharSequence)subCalendar.getTimeZoneId()) || !this.getJodaIcal4jTimeZoneMapper().getSupportedTimeZoneIds().contains(subCalendar.getTimeZoneId())) {
            this.addFieldError(fieldErrors, "timeZoneId", this.getText("calendar3.error.invalidfield"));
        }
    }

    protected String getText(String i18nKey) {
        return this.getI18NBean().getText(i18nKey);
    }

    @Override
    public SubCalendarEvent transform(final SubCalendarEvent toBeTransformed, final VEvent raw) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return this.getSubCalendarEventTransformerFactory().getInviteesTransformer().transform(super.transform(toBeTransformed, raw), currentUser, new SubCalendarEventTransformerFactory.TransformParameters(){

            @Override
            public VEvent getRawEvent() {
                return raw;
            }

            @Override
            public boolean isReadOnly() {
                return !toBeTransformed.isEditable();
            }
        });
    }

    @Override
    public Calendar getSubCalendarContent(T subCalendar) throws Exception {
        return new XConfluencePersonPropertyToAttendeePropertyTransformer(this.getGlobalSettingsManager().getGlobalSettings().getBaseUrl(), this.getUserAccessor()).transform(super.getSubCalendarContent(subCalendar));
    }

    @Override
    public void setSubCalendarContent(T subCalendar, Calendar subCalendarData) throws Exception {
        super.setSubCalendarContent(subCalendar, new Transformer<Calendar>(){

            public Calendar transform(Calendar subCalendarData) {
                ComponentList eventComponents = subCalendarData.getComponents("VEVENT");
                if (null != eventComponents) {
                    for (VEvent eventComponent : eventComponents) {
                        Predicate confluenceAttendeePredicate;
                        PropertyList eventComponentProps;
                        PropertyList attendeeProperties;
                        ArrayList confluenceAttendeeProperties;
                        VEvent baseEvent;
                        if (!this.isRescheduledRecurrence(eventComponent) || null == (baseEvent = this.getBaseEvent(eventComponent, (List<VEvent>)eventComponents)) || !(confluenceAttendeeProperties = new ArrayList(Collections2.filter((Collection)(null == (attendeeProperties = (eventComponentProps = eventComponent.getProperties()).getProperties("ATTENDEE")) ? Collections.emptyList() : attendeeProperties), (Predicate)(confluenceAttendeePredicate = attendee -> null != attendee.getParameter("X-CONFLUENCE-USER-KEY"))))).isEmpty()) continue;
                        PropertyList baseEventAttendeeProperties = baseEvent.getProperties("ATTENDEE");
                        ArrayList baseEventConfluenceAttendeeProperties = new ArrayList(Collections2.filter((Collection)(null == baseEventAttendeeProperties ? Collections.emptyList() : baseEventAttendeeProperties), (Predicate)confluenceAttendeePredicate));
                        for (Attendee baseEventConfluenceAttendee : baseEventConfluenceAttendeeProperties) {
                            eventComponentProps.add((Property)new Attendee(baseEventConfluenceAttendee.getParameters(), URI.create(baseEventConfluenceAttendee.getValue())));
                        }
                    }
                }
                return subCalendarData;
            }

            private VEvent getBaseEvent(VEvent rescheduledRecurrence, List<VEvent> eventComponents) {
                Property rescheduledRecurrenceUid = rescheduledRecurrence.getProperty("UID");
                if (null != rescheduledRecurrenceUid && StringUtils.isNotBlank((CharSequence)rescheduledRecurrenceUid.getValue())) {
                    for (VEvent event : eventComponents) {
                        Property uidProperty = event.getProperty("UID");
                        if (null == uidProperty || !StringUtils.equals((CharSequence)rescheduledRecurrenceUid.getValue(), (CharSequence)uidProperty.getValue()) || this.isRescheduledRecurrence(event)) continue;
                        return event;
                    }
                }
                return null;
            }

            private boolean isRescheduledRecurrence(VEvent event) {
                Property recurrenceId = event.getProperty("RECURRENCE-ID");
                return null != recurrenceId && StringUtils.isNotBlank((CharSequence)recurrenceId.getValue());
            }
        }.transform(subCalendarData));
    }

    @Override
    public boolean hasReloadEventsPrivilege(T subCalendar, ConfluenceUser user) {
        return this.hasViewEventPrivilege(subCalendar, user);
    }

    @Override
    public void refresh(T subCalendar) {
    }
}

