/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.extra.calendar3.JodaIcal4jDateTimeConverter;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraCoreRestPathsConstructor;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraDateStamp;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraICalendarRestPathsConstructor;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraSoftwareRestPathsConstructor;
import com.atlassian.confluence.extra.calendar3.calendarstore.RestOperation;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetApiVersionResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetAutoCompleteResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetCalendarFromEndPointResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetDateFieldsInternalResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetGreenHopperSprintDatesForJqlResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetIssueCountWithJiraApiResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetIssueCountWithJiraCloudApiResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetIssuesReturnedByJqlResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetJqlAutoCompleteDataResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetProjectResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetProjectsResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetQueryOptionsResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.GetSearchFilterJqlResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.IsGreenHopperSprintDatesSupportedResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.JqlValidationResultResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.SearchForProjectsCloudResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.SearchForProjectsDcResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.UpdateEventFieldsResponseHandler;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.UpdateProjectVersionReleaseDateResponseHandler;
import com.atlassian.confluence.extra.calendar3.events.JiraApplinkRequest;
import com.atlassian.confluence.extra.calendar3.exception.CalendarException;
import com.atlassian.confluence.extra.calendar3.model.JiraDateField;
import com.atlassian.confluence.extra.calendar3.model.JqlAutoCompleteData;
import com.atlassian.confluence.extra.calendar3.model.JqlAutoCompleteResult;
import com.atlassian.confluence.extra.calendar3.model.JqlValidationResult;
import com.atlassian.confluence.extra.calendar3.model.Project;
import com.atlassian.confluence.extra.calendar3.model.ProjectPickerResultWrapper;
import com.atlassian.confluence.extra.calendar3.model.QueryOptions;
import com.atlassian.confluence.extra.calendar3.util.Ical4jIoUtil;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.core.util.PairType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.integration.jira.JiraAuthenticationRequiredException;
import com.atlassian.integration.jira.JiraService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultJiraAccessor
implements JiraAccessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJiraAccessor.class);
    private static final String DISABLE_EXPANDED_FIELD_RETRIEVAL = "teamcal.calendar3.disable.expanded.jira.field.retrieval";
    private static final int ICALENDAR_STREAM_SOCKET_TIMEOUT = Integer.getInteger("com.atlassian.confluence.extra.calendar3.jira.timeout.socket", 20000);
    private static final boolean GREENHOPPER_SPRINT_DATES_ENABLED = BooleanUtils.toBoolean((String)System.getProperty("com.atlassian.confluence.extra.calendar3.greenhopper.sprint.enabled", Boolean.TRUE.toString()));
    private static final boolean CACHE_JIRA_ACCESSOR_ENABLE = BooleanUtils.toBoolean((String)System.getProperty("com.atlassian.confluence.extra.calendar3.cache.jira.accessor", Boolean.TRUE.toString()));
    private final ApplicationLinkService applicationLinkService;
    private final JodaIcal4jDateTimeConverter jodaIcal4jDateTimeConverter;
    private final CacheManager cacheManager;
    private final GlobalSettingsManager globalSettingsManager;
    private final DarkFeatureManager darkFeatureManager;
    private final EventPublisher eventPublisher;
    private final JiraService jiraService;
    private final String cacheJiraQueryOption;
    private final String cacheGreenhopperSprintDate;
    private int confluenceSocketTimeoutSetting;

    @Autowired
    public DefaultJiraAccessor(@ComponentImport ApplicationLinkService applicationLinkService, JodaIcal4jDateTimeConverter jodaIcal4jDateTimeConverter, @ComponentImport CacheManager cacheManager, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport DarkFeatureManager darkFeatureManager, @ComponentImport EventPublisher eventPublisher, @ComponentImport JiraService jiraService) {
        this.applicationLinkService = applicationLinkService;
        this.jodaIcal4jDateTimeConverter = jodaIcal4jDateTimeConverter;
        this.cacheManager = cacheManager;
        this.globalSettingsManager = globalSettingsManager;
        this.darkFeatureManager = darkFeatureManager;
        this.eventPublisher = eventPublisher;
        this.jiraService = jiraService;
        this.cacheJiraQueryOption = this.getClass().getName() + ":cache-jira-query-option";
        this.cacheGreenhopperSprintDate = this.getClass().getName() + ":cache-greenhopper-spint-date";
        this.confluenceSocketTimeoutSetting = -1;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getCacheQueryOptionJIRA() != null) {
            this.getCacheQueryOptionJIRA().removeAll();
        }
        if (this.getCacheGreenHopperSprintDate() != null) {
            this.getCacheGreenHopperSprintDate().removeAll();
        }
    }

    private int getSocketTimeout() {
        ConfluenceHttpParameters httpParameters;
        if (this.confluenceSocketTimeoutSetting != -1) {
            return Math.max(this.confluenceSocketTimeoutSetting, ICALENDAR_STREAM_SOCKET_TIMEOUT);
        }
        Settings settings = this.globalSettingsManager.getGlobalSettings();
        if (settings != null && (httpParameters = settings.getConfluenceHttpParameters()) != null) {
            this.confluenceSocketTimeoutSetting = httpParameters.getSocketTimeout();
        }
        return Math.max(this.confluenceSocketTimeoutSetting, ICALENDAR_STREAM_SOCKET_TIMEOUT);
    }

    public Collection<ApplicationLink> getLinkedJiraApplications() {
        return Lists.newArrayList((Iterable)this.applicationLinkService.getApplicationLinks(JiraApplicationType.class));
    }

    public ApplicationLink getLinkedJiraInstance(String applicationId) {
        for (ApplicationLink jiraLink : this.getLinkedJiraApplications()) {
            if (!StringUtils.equals((CharSequence)jiraLink.getId().get(), (CharSequence)applicationId)) continue;
            return jiraLink;
        }
        return null;
    }

    private void publishJiraApplinkRequestEvent(ApplicationLink jiraLink, RestOperation operation) {
        this.eventPublisher.publish((Object)new JiraApplinkRequest(this, AuthenticatedUserThreadLocal.get(), jiraLink, operation.getOperation()));
    }

    public QueryOptions getQueryOptions(ApplicationLink jiraLink) throws CredentialsRequiredException, ResponseException {
        QueryOptions queryOptions = null;
        String keyJiraOptionCache = this.getKeyUserCache(jiraLink);
        Cache jiraOptionCache = this.getCacheQueryOptionJIRA();
        if (jiraOptionCache != null) {
            queryOptions = (QueryOptions)jiraOptionCache.get((Object)keyJiraOptionCache);
        }
        if (queryOptions == null) {
            String endPoint = JiraICalendarRestPathsConstructor.getQueryOptionsEndPoint() + "?_=" + System.currentTimeMillis();
            ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
            try {
                this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_QUERY_OPTIONS);
                queryOptions = (QueryOptions)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.GET, endPoint).setSoTimeout(this.getSocketTimeout())).execute((ApplicationLinkResponseHandler)new GetQueryOptionsResponseHandler(requestFactory, jiraLink, endPoint));
                if (jiraOptionCache != null) {
                    jiraOptionCache.put((Object)keyJiraOptionCache, (Object)queryOptions);
                }
            }
            catch (JiraAccessor.JiraPreConditionUnmetException projectsRestEndPointNotFound) {
                LOG.debug("API end point to get query options from {}.", (Object)projectsRestEndPointNotFound.getJiraLink().getDisplayUrl().toString(), (Object)projectsRestEndPointNotFound);
                return new QueryOptions.Builder().projects(new ArrayList<Project>(this.getProjects(jiraLink))).jqlNotSupported(true).build();
            }
            catch (ResponseException applinkResponseError) {
                Throwable cause = applinkResponseError.getCause();
                if (cause instanceof CredentialsRequiredException) {
                    throw (CredentialsRequiredException)cause;
                }
                throw applinkResponseError;
            }
        }
        return queryOptions;
    }

    public JqlAutoCompleteData getJqlAutoCompleteData(ApplicationLink jiraLink) throws CredentialsRequiredException, ResponseException {
        JqlAutoCompleteData jqlAutoCompleteData;
        String endPoint = JiraCoreRestPathsConstructor.getJqlAutoCompleteDataEndPoint() + "?_=" + System.currentTimeMillis();
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_JQL_AUTO_COMPLETE_DATA);
            jqlAutoCompleteData = (JqlAutoCompleteData)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.GET, endPoint).setSoTimeout(this.getSocketTimeout())).execute((ApplicationLinkResponseHandler)new GetJqlAutoCompleteDataResponseHandler(requestFactory, jiraLink, endPoint));
        }
        catch (JiraAccessor.JiraPreConditionUnmetException endPointNotFoundException) {
            LOG.warn("API end point to get jql autocomplete data from {}. Returning empty response.", (Object)endPointNotFoundException.getJiraLink().getDisplayUrl().toString(), (Object)endPointNotFoundException);
            return new JqlAutoCompleteData("", "", "");
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
        return jqlAutoCompleteData;
    }

    public JqlAutoCompleteResult getAutoCompleteV2(ApplicationLink jiraLink, String fieldName, String fieldValue) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraCoreRestPathsConstructor.getAutoCompleteEndPointVersion2(fieldName, fieldValue);
        return this.getAutoComplete(jiraLink, endPoint, RestOperation.JQL_AUTOCOMPLETE_V2);
    }

    public Collection<Project> getProjects(ApplicationLink jiraLink) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraCoreRestPathsConstructor.getProjectListEndPoint(this.getApiVersion(jiraLink)) + "?_=" + System.currentTimeMillis();
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_PROJECTS);
            return (Collection)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new GetProjectsResponseHandler(requestFactory, jiraLink, endPoint));
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    public Project getProject(ApplicationLink jiraLink, String projectKey) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraCoreRestPathsConstructor.getProjectEndPoint(projectKey);
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_PROJECT);
            return (Project)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new GetProjectResponseHandler(requestFactory, jiraLink, endPoint));
        }
        catch (JiraAccessor.JiraPreConditionUnmetException projectRestEndPointNotFound) {
            return null;
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    public ProjectPickerResultWrapper searchForProjects(ApplicationLink jiraLink, String query, int maxResults, boolean allowEmptyQuery) throws CredentialsRequiredException, ResponseException {
        try {
            if (this.jiraService.isJiraCloudAppLink(jiraLink.getId())) {
                return this.searchForProjectsCloud(jiraLink, query, maxResults);
            }
            return this.searchForProjectsDc(jiraLink, query, maxResults, allowEmptyQuery);
        }
        catch (JiraAuthenticationRequiredException jiraAuthenticationRequiredException) {
            throw new CredentialsRequiredException((AuthorisationURIGenerator)jiraLink.createAuthenticatedRequestFactory(), jiraAuthenticationRequiredException.getMessage());
        }
    }

    @VisibleForTesting
    ProjectPickerResultWrapper searchForProjectsCloud(ApplicationLink jiraLink, String query, int maxResults) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraCoreRestPathsConstructor.getSearchForProjectsCloudEndPoint(query, maxResults);
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.SEARCH_FOR_PROJECTS);
            return (ProjectPickerResultWrapper)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new SearchForProjectsCloudResponseHandler(requestFactory, jiraLink, endPoint));
        }
        catch (JiraAccessor.JiraPreConditionUnmetException projectsRestEndPointNotFound) {
            LOG.warn("API end point to search for projects from {}.", (Object)projectsRestEndPointNotFound.getJiraLink().getDisplayUrl().toString(), (Object)projectsRestEndPointNotFound);
            return new ProjectPickerResultWrapper(null, null, null);
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    @VisibleForTesting
    ProjectPickerResultWrapper searchForProjectsDc(ApplicationLink jiraLink, String query, int maxResults, boolean allowEmptyQuery) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraCoreRestPathsConstructor.getSearchForProjectsDcEndPoint(query, maxResults, allowEmptyQuery);
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.SEARCH_FOR_PROJECTS);
            return (ProjectPickerResultWrapper)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new SearchForProjectsDcResponseHandler(requestFactory, jiraLink, endPoint));
        }
        catch (JiraAccessor.JiraPreConditionUnmetException projectsRestEndPointNotFound) {
            LOG.warn("API end point to search for projects from {}.", (Object)projectsRestEndPointNotFound.getJiraLink().getDisplayUrl().toString(), (Object)projectsRestEndPointNotFound);
            return new ProjectPickerResultWrapper(null, null, null);
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    public void updateProjectVersionReleaseDate(ApplicationLink jiraLink, String versionId, Date date) throws CredentialsRequiredException, ResponseException, JSONException {
        String dateStamp = JiraDateStamp.fromDate(date);
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest putRequest = requestFactory.createRequest(Request.MethodType.PUT, JiraCoreRestPathsConstructor.getUpdateProjectVersionReleaseDateEndPoint(versionId, this.getApiVersion(jiraLink)));
        this.setApplicationLinkRequestBody(putRequest, new JSONObject().put("releaseDate", (Object)dateStamp).toString(), "application/json");
        this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.UPDATE_PROJECT_VERSION_RELEASE_DATE);
        putRequest.execute((ApplicationLinkResponseHandler)new UpdateProjectVersionReleaseDateResponseHandler(requestFactory, jiraLink, versionId));
    }

    @Deprecated
    public void updateEventFields(ApplicationLink jiraLink, Map<String, List<PairType>> eventFields) throws CredentialsRequiredException, ResponseException, JSONException {
        this.updateEventFields(jiraLink, eventFields, null);
    }

    public void updateEventFields(ApplicationLink jiraLink, Map<String, List<PairType>> eventFields, String timeZoneId) throws CredentialsRequiredException, ResponseException, JSONException {
        String apiVersion = this.getApiVersion(jiraLink);
        if (apiVersion.equals("2.0.alpha1")) {
            throw new CalendarException("calendar3.error.edit.jira.api.version");
        }
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        for (Map.Entry<String, List<PairType>> eventField : eventFields.entrySet()) {
            JSONObject updateObject = this.enrichEventField(eventField, timeZoneId);
            ApplicationLinkRequest putRequest = requestFactory.createRequest(Request.MethodType.PUT, JiraCoreRestPathsConstructor.getIssueEndpoint(apiVersion, eventField));
            this.setApplicationLinkRequestBody(putRequest, new JSONObject().put("update", (Object)updateObject).toString(), "application/json");
            try {
                this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.UPDATE_EVENT_FIELDS);
                putRequest.execute((ApplicationLinkResponseHandler)new UpdateEventFieldsResponseHandler(requestFactory, jiraLink, eventField));
            }
            catch (ResponseException re) {
                throw new CalendarException((Exception)((Object)re), "calendar3.error.edit.jira.field", UpdateEventFieldsResponseHandler.getFieldNames(eventField.getValue()), jiraLink.getName());
            }
        }
    }

    private JSONObject enrichEventField(Map.Entry<String, List<PairType>> eventField, String timeZoneId) {
        JSONObject updateObject = new JSONObject();
        for (PairType field : eventField.getValue()) {
            updateObject.put(field.getKey().toString(), (Object)new JSONArray().put((Object)new JSONObject().put("set", (Object)(timeZoneId == null ? JiraDateStamp.fromDate((Date)field.getValue()) : JiraDateStamp.fromDateAndTimeZoneId((Date)field.getValue(), timeZoneId)))));
        }
        return updateObject;
    }

    public boolean canEditCalendar(ApplicationLink jiraLink) throws ResponseException, CredentialsRequiredException {
        return jiraLink != null && "2".equals(this.getApiVersion(jiraLink));
    }

    public Calendar getCalendarByJql(ApplicationLink jiraLink, String jql, JiraAccessor.CalendarOptions calendarOptions, long start, long end) throws CredentialsRequiredException, ResponseException, IOException, ParserException {
        String endPoint = JiraICalendarRestPathsConstructor.getIcalendarEndPointByJql(false, jql, calendarOptions, start, end);
        try {
            Calendar calendar = this.getCalendarFromEndPoint(jiraLink, endPoint, jql);
            if (calendarOptions.isIncludeGreenHopperSprints()) {
                calendar.getComponents().addAll((Collection)this.getGreenHopperSprintDates(jiraLink, jql));
            }
            return calendar;
        }
        catch (JiraAccessor.JiraPreConditionUnmetException iCalendarByJqlEndPointNotFound) {
            LOG.debug("API end point to get query options from {}.", (Object)iCalendarByJqlEndPointNotFound.getJiraLink().getDisplayUrl().toString(), (Object)iCalendarByJqlEndPointNotFound);
            return this.getCalendarFromEndPoint(jiraLink, JiraICalendarRestPathsConstructor.getIcalendarEndPointByJql(true, jql, calendarOptions, start, end), jql);
        }
    }

    private Calendar getCalendarFromEndPoint(ApplicationLink jiraLink, String endPoint, String jql) throws CredentialsRequiredException, IOException, ParserException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        UtilTimerStack.push((String)"DefaultJiraAccessor.getCalendarFromEndPoint()");
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_CALENDAR_FROM_ENDPOINT);
            String icalendarText = (String)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.GET, endPoint).setSoTimeout(this.getSocketTimeout())).execute((ApplicationLinkResponseHandler)new GetCalendarFromEndPointResponseHandler(requestFactory, jiraLink, jql, endPoint));
            if (StringUtils.isEmpty((CharSequence)icalendarText)) {
                throw new JiraAccessor.JiraResponseException(String.format("The response from %s didn't make sense", jql));
            }
            Calendar calendar = Ical4jIoUtil.newCalendarBuilder().build((Reader)new StringReader(icalendarText));
            return calendar;
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
        finally {
            UtilTimerStack.pop((String)"DefaultJiraAccessor.getCalendarFromEndPoint()");
        }
    }

    public Calendar getCalendarBySearchFilter(ApplicationLink jiraLink, long searchFilter, JiraAccessor.CalendarOptions calendarOptions, long start, long end) throws CredentialsRequiredException, ResponseException, IOException, ParserException {
        this.checkSearchFilterExists(jiraLink, searchFilter);
        this.getSearchFilterJql(jiraLink, searchFilter);
        String endPoint = JiraICalendarRestPathsConstructor.getIcalendarEndPointBySearchFilter(searchFilter, calendarOptions, start, end);
        String jql = "filter=" + searchFilter;
        Calendar calendar = this.getCalendarFromEndPoint(jiraLink, endPoint, jql);
        if (calendarOptions.isIncludeGreenHopperSprints()) {
            calendar.getComponents().addAll((Collection)this.getGreenHopperSprintDates(jiraLink, searchFilter));
        }
        return calendar;
    }

    private void checkSearchFilterExists(ApplicationLink jiraLink, long searchFilterId) throws CredentialsRequiredException, ResponseException {
        try {
            this.getSearchFilterJql(jiraLink, searchFilterId);
        }
        catch (JiraAccessor.JiraPreConditionUnmetException jiraPreConditionUnmet) {
            LOG.debug("Unable to check if search filter {} exists. The JIRA REST end point for that does not exist.", (Object)searchFilterId, (Object)jiraPreConditionUnmet);
        }
    }

    public Collection<JiraDateField> getDateFields(ApplicationLink jiraLink, String jql) throws CredentialsRequiredException, ResponseException {
        boolean isUsingExpandedFieldRetrieval = this.isUsingExpandedFieldRetrieval();
        return this.getDateFieldsInternal(jiraLink, JiraICalendarRestPathsConstructor.getDateFieldsListEndPoint(jql, isUsingExpandedFieldRetrieval), jql);
    }

    private Collection<JiraDateField> getDateFieldsInternal(ApplicationLink jiraLink, String endPoint, String jql) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        LOG.debug("Retrieving date fields from Jira endpoint {}", (Object)endPoint);
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_DATE_FIELDS_INTERNAL);
            return (Collection)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new GetDateFieldsInternalResponseHandler(requestFactory, jql));
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    private boolean isUsingExpandedFieldRetrieval() {
        return this.darkFeatureManager.isEnabledForAllUsers(DISABLE_EXPANDED_FIELD_RETRIEVAL).orElse(false) == false;
    }

    public Collection<JiraDateField> getDateFields(ApplicationLink jiraLink, long searchFilterId) throws CredentialsRequiredException, ResponseException {
        String jql = "filter=" + searchFilterId;
        return this.getDateFieldsInternal(jiraLink, JiraICalendarRestPathsConstructor.getDateFieldsListEndPoint(searchFilterId, this.isUsingExpandedFieldRetrieval()), jql);
    }

    public JqlValidationResult validateJql(ApplicationLink jiraLink, String jql) throws CredentialsRequiredException, ResponseException, IOException {
        String endPoint = JiraICalendarRestPathsConstructor.getJqlValidationEndPoint();
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.VALIDATE_JQL);
            return (JqlValidationResult)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.POST, endPoint).addRequestParameters(new String[]{"jql", jql})).execute((ApplicationLinkResponseHandler)new JqlValidationResultResponseHandler(requestFactory, jql));
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    public JqlAutoCompleteResult getAutoComplete(ApplicationLink jiraLink, String fieldName, String fieldValue) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraCoreRestPathsConstructor.getJqlAutocompleteEndPoint(fieldName, fieldValue);
        return this.getAutoComplete(jiraLink, endPoint, RestOperation.JQL_AUTOCOMPLETE);
    }

    private JqlAutoCompleteResult getAutoComplete(ApplicationLink jiraLink, String endPoint, RestOperation operation) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            this.publishJiraApplinkRequestEvent(jiraLink, operation);
            return (JqlAutoCompleteResult)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new GetAutoCompleteResponseHandler(requestFactory, endPoint));
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            throw applinkResponseError;
        }
    }

    public boolean isGreenHopperSprintDatesSupported(ApplicationLink jiraLink) {
        if (!GREENHOPPER_SPRINT_DATES_ENABLED) {
            return false;
        }
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        String endPoint = JiraSoftwareRestPathsConstructor.getGreenHopperSprintDatesEndPoint(null);
        Boolean isGreenHopperSprint = null;
        String keyGreenHopperSprint = this.getKeyUserCache(jiraLink);
        Cache greenHopperSprintDateCache = this.getCacheGreenHopperSprintDate();
        if (greenHopperSprintDateCache != null) {
            Object result = greenHopperSprintDateCache.get((Object)keyGreenHopperSprint);
            Boolean bl = isGreenHopperSprint = result != null ? (Boolean)result : null;
        }
        if (isGreenHopperSprint == null) {
            try {
                this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.IS_GREENHOPPER_SPRINT_DATES_SUPPORTED);
                isGreenHopperSprint = (Boolean)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new IsGreenHopperSprintDatesSupportedResponseHandler(requestFactory));
                if (greenHopperSprintDateCache != null) {
                    greenHopperSprintDateCache.put((Object)keyGreenHopperSprint, (Object)isGreenHopperSprint);
                }
            }
            catch (CredentialsRequiredException authorizationRequired) {
                LOG.info("GreenHopper sprint dates support detection requires authentication - assuming it is supported", (Throwable)authorizationRequired);
                return true;
            }
            catch (Exception e) {
                LOG.error("Unable to property determine if GreenHopper sprint dates are supported", (Throwable)e);
                return false;
            }
        }
        return isGreenHopperSprint;
    }

    private ComponentList getGreenHopperSprintDates(ApplicationLink jiraLink, String jql) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraSoftwareRestPathsConstructor.getGreenHopperSprintDatesEndPoint(jql);
        return this.getGreenHopperSprintDates(jiraLink, endPoint, jql);
    }

    private ComponentList getGreenHopperSprintDates(ApplicationLink jiraLink, long searchFilterId) throws CredentialsRequiredException, ResponseException {
        String endPoint = JiraSoftwareRestPathsConstructor.getGreenHopperSprintDatesEndPoint(searchFilterId);
        String jql = "filter=" + searchFilterId;
        return this.getGreenHopperSprintDates(jiraLink, endPoint, jql);
    }

    private ComponentList getGreenHopperSprintDates(ApplicationLink jiraLink, String endPoint, String jql) throws CredentialsRequiredException, ResponseException {
        ComponentList sprintVEvents = new ComponentList();
        UtilTimerStack.push((String)"DefaultJiraAccessor.getGreenHopperSprintDates()");
        if (this.isGreenHopperSprintDatesSupported(jiraLink)) {
            ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
            try {
                this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_GREENHOPPER_SPRINT_DATES);
                ComponentList componentList = (ComponentList)requestFactory.createRequest(Request.MethodType.GET, endPoint).execute((ApplicationLinkResponseHandler)new GetGreenHopperSprintDatesForJqlResponseHandler(requestFactory, jiraLink, jql, this.jodaIcal4jDateTimeConverter));
                return componentList;
            }
            catch (ResponseException applinkResponseError) {
                Throwable cause = applinkResponseError.getCause();
                if (cause instanceof CredentialsRequiredException) {
                    throw (CredentialsRequiredException)cause;
                }
                throw applinkResponseError;
            }
            finally {
                UtilTimerStack.pop((String)"DefaultJiraAccessor.getGreenHopperSprintDates()");
            }
        }
        return sprintVEvents;
    }

    private String getApiVersion(ApplicationLink jiraLink) throws ResponseException, CredentialsRequiredException {
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, JiraCoreRestPathsConstructor.getApiVersionEndpoint());
        this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_API_VERSION);
        return (String)request.execute((ApplicationLinkResponseHandler)new GetApiVersionResponseHandler(requestFactory));
    }

    public String getSearchFilterJql(ApplicationLink jiraLink, long searchFilterId) throws ResponseException, CredentialsRequiredException {
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        String endPoint = JiraCoreRestPathsConstructor.getSearchFilterEndpoint(searchFilterId);
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, endPoint);
        this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_SEARCH_FILTER_JQL);
        return (String)request.execute((ApplicationLinkResponseHandler)new GetSearchFilterJqlResponseHandler(requestFactory, jiraLink, endPoint));
    }

    public int getIssuesReturnedByJql(ApplicationLink jiraLink, String jql, Collection<String> singleDateFields, Collection<String> durations) throws ResponseException, CredentialsRequiredException {
        String endPoint = JiraICalendarRestPathsConstructor.getIssuesCountEndPoint();
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        try {
            ApplicationLinkRequest resultsCountRequest = (ApplicationLinkRequest)((ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.POST, endPoint).addRequestParameters(new String[]{"jql", jql})).addRequestParameters(new String[]{"includeFixVersions", (singleDateFields != null && singleDateFields.contains("versiondue") ? Boolean.TRUE : Boolean.FALSE).toString()});
            if (singleDateFields != null) {
                for (String singleDateField : Collections2.filter(singleDateFields, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"sprint")))) {
                    resultsCountRequest.addRequestParameters(new String[]{"dateFieldName", singleDateField});
                }
            }
            if (durations != null) {
                for (String durationString : durations) {
                    resultsCountRequest.addRequestParameters(new String[]{"duration", durationString});
                }
            }
            this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_ISSUES_RETURNED_BY_JQL);
            return (Integer)resultsCountRequest.execute((ApplicationLinkResponseHandler)new GetIssuesReturnedByJqlResponseHandler(requestFactory, jiraLink, endPoint));
        }
        catch (ResponseException applinkResponseError) {
            Throwable cause = applinkResponseError.getCause();
            if (cause instanceof CredentialsRequiredException) {
                throw (CredentialsRequiredException)cause;
            }
            if (applinkResponseError instanceof JiraAccessor.JiraPreConditionUnmetException && ((JiraAccessor.JiraPreConditionUnmetException)((Object)applinkResponseError)).getPreCondition() == JiraAccessor.JiraPreConditionUnmetException.PreCondition.EndpointNotFound) {
                return this.getIssueCountWithJiraApi(jiraLink, jql);
            }
            throw applinkResponseError;
        }
    }

    private ApplicationLinkRequest setApplicationLinkRequestBody(ApplicationLinkRequest applicationLinkRequest, String requestBody, String requestContentType) {
        if (applicationLinkRequest != null) {
            Method setRequestBodyMethod = null;
            try {
                setRequestBodyMethod = applicationLinkRequest.getClass().getMethod("setRequestBody", String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                LOG.debug(e.getMessage());
            }
            if (setRequestBodyMethod != null) {
                try {
                    setRequestBodyMethod.invoke((Object)applicationLinkRequest, requestBody, requestContentType);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error(e.getMessage());
                }
            } else {
                applicationLinkRequest.setRequestBody(requestBody, requestContentType);
            }
        }
        return applicationLinkRequest;
    }

    private int getIssueCountWithJiraApi(ApplicationLink jiraLink, String jql) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequestFactory requestFactory = jiraLink.createAuthenticatedRequestFactory();
        boolean isCloud = this.jiraService.isJiraCloudAppLink(jiraLink.getId());
        this.publishJiraApplinkRequestEvent(jiraLink, RestOperation.GET_ISSUE_COUNT_WITH_JIRA_API);
        return isCloud ? this.getIssueCountForCloud(requestFactory, jql) : this.getIssueCountForDC(requestFactory, jql);
    }

    private int getIssueCountForCloud(ApplicationLinkRequestFactory requestFactory, String jql) throws CredentialsRequiredException, ResponseException {
        LOG.trace("Using 'rest/api/2/search/approximate-count' endpoint to count issue for Jira Cloud as '/rest/api/2/search' JVIS one is deprecated");
        String endPoint = JiraCoreRestPathsConstructor.getIssueCountEndpoint(true);
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.POST, endPoint);
        request.setRequestBody(new JSONObject(Map.of("jql", jql)).toString(), "application/json");
        return (Integer)request.execute((ApplicationLinkResponseHandler)new GetIssueCountWithJiraCloudApiResponseHandler(requestFactory, endPoint, jql));
    }

    private int getIssueCountForDC(ApplicationLinkRequestFactory requestFactory, String jql) throws CredentialsRequiredException, ResponseException {
        JSONObject body = new JSONObject(Map.of("jql", jql, "startAt", String.valueOf(0), "maxResults", String.valueOf(1)));
        String endPoint = JiraCoreRestPathsConstructor.getIssueCountEndpoint(false);
        ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.POST, endPoint);
        request.setRequestBody(body.toString(), "application/json");
        return (Integer)request.execute((ApplicationLinkResponseHandler)new GetIssueCountWithJiraApiResponseHandler(requestFactory, endPoint, jql));
    }

    private Cache getCacheQueryOptionJIRA() {
        if (!CACHE_JIRA_ACCESSOR_ENABLE) {
            return null;
        }
        return this.cacheManager.getCache(this.cacheJiraQueryOption, null, new CacheSettingsBuilder().local().build());
    }

    private Cache getCacheGreenHopperSprintDate() {
        if (!CACHE_JIRA_ACCESSOR_ENABLE) {
            return null;
        }
        return this.cacheManager.getCache(this.cacheGreenhopperSprintDate, null, new CacheSettingsBuilder().local().build());
    }

    private String getKeyUserCache(ApplicationLink applicationLink) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return currentUser == null || currentUser.getKey() == null || applicationLink == null || applicationLink.getId() == null ? "" : currentUser.getKey().toString() + ":" + applicationLink.getId().toString();
    }
}

