/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.core.util.PairType;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class JiraCoreRestPathsConstructor {
    public static final String REST_JQL_ISSUE_SEARCH_DC_PATH = "/rest/api/2/search";
    public static final String REST_JQL_ISSUE_COUNT_CLOUD_PATH = "/rest/api/2/search/approximate-count";
    public static final String API_VERSION_LEGACY = "2.0.alpha1";
    public static final String API_VERSION_FINAL = "2";

    private JiraCoreRestPathsConstructor() {
    }

    static String getJqlAutocompleteEndPoint(String fieldName, String fieldValue) {
        return String.format("/rest/api/1.0/jql/autocomplete?_=%d&fieldName=%s&fieldValue=%s", System.currentTimeMillis(), HtmlUtil.urlEncode((String)fieldName), HtmlUtil.urlEncode((String)StringUtils.defaultString((String)fieldValue), (Charset)GeneralUtil.getDefaultCharset()));
    }

    static String getAutoCompleteEndPointVersion2(String fieldName, String fieldValue) {
        return String.format("/rest/api/2/jql/autocompletedata/suggestions?_%d&fieldName=%s&fieldValue=%s", System.currentTimeMillis(), HtmlUtil.urlEncode((String)fieldName), HtmlUtil.urlEncode((String)StringUtils.defaultString((String)fieldValue), (Charset)GeneralUtil.getDefaultCharset()));
    }

    static String getJqlAutoCompleteDataEndPoint() {
        return "/rest/api/2/jql/autocompletedata";
    }

    static String getProjectListEndPoint(String apiVersion) {
        return "/rest/api/" + apiVersion + "/project";
    }

    static String getProjectEndPoint(String projectKey) {
        return "/rest/api/2/project/" + HtmlUtil.urlEncode((String)projectKey);
    }

    static String getApiVersionEndpoint() {
        return "/rest/api/2/serverInfo";
    }

    static String getSearchForProjectsDcEndPoint(String query, int maxResults, boolean allowEmptyQuery) {
        return String.format("/rest/api/2/projects/picker?_%d&maxResults=%d&query=%s&allowEmptyQuery=%b", System.currentTimeMillis(), maxResults, HtmlUtil.urlEncode((String)StringUtils.defaultString((String)query), (Charset)GeneralUtil.getDefaultCharset()), allowEmptyQuery);
    }

    static String getSearchForProjectsCloudEndPoint(String query, int maxResults) {
        return String.format("/rest/api/2/project/search?_%d&maxResults=%d&query=%s", System.currentTimeMillis(), maxResults, HtmlUtil.urlEncode((String)StringUtils.defaultString((String)query), (Charset)GeneralUtil.getDefaultCharset()));
    }

    static String getUpdateProjectVersionReleaseDateEndPoint(String versionId, String apiVersion) {
        return "/rest/api/" + apiVersion + "/version/" + versionId;
    }

    static String getIssueEndpoint(String apiVersion, Map.Entry<String, List<PairType>> eventField) {
        return "/rest/api/" + apiVersion + "/issue/" + HtmlUtil.urlEncode((String)eventField.getKey());
    }

    static String getSearchFilterEndpoint(long searchFilterId) {
        return "/rest/api/2/filter/" + searchFilterId;
    }

    static String getIssueCountEndpoint(boolean isCloud) {
        return isCloud ? REST_JQL_ISSUE_COUNT_CLOUD_PATH : REST_JQL_ISSUE_SEARCH_DC_PATH;
    }
}

