/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore;

import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.util.CalendarUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.core.util.PairType;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class JiraICalendarRestPathsConstructor {
    private static final String ICAL_ENDPOINT_PREFIX = "/rest/ical/1.0/ical";

    private JiraICalendarRestPathsConstructor() {
    }

    static String getQueryOptionsEndPoint() {
        return "/rest/ical/1.0/ical/config/query/options";
    }

    static String getJqlValidationEndPoint() {
        return "/rest/ical/1.0/ical/util/jql/validate";
    }

    static String getIssuesCountEndPoint() {
        return "/rest/ical/1.0/ical/util/jql/count";
    }

    static String getIcalendarEndPointByJql(boolean oldEndpoint, String jql, JiraAccessor.CalendarOptions calendarOptions, long start, long end) {
        return ICAL_ENDPOINT_PREFIX + (oldEndpoint ? "/search/events.ics" : "/search/jql/events.ics") + "?_=" + System.currentTimeMillis() + "&jql=" + HtmlUtil.urlEncode((String)jql) + JiraICalendarRestPathsConstructor.appendEndPointDateFieldNameParam(calendarOptions) + JiraICalendarRestPathsConstructor.appendEndPointFixVersionParam(calendarOptions) + JiraICalendarRestPathsConstructor.appendEndPointRangeDateLimit(start, end);
    }

    static String getIcalendarEndPointBySearchFilter(long searchFilterId, JiraAccessor.CalendarOptions calendarOptions, long start, long end) {
        return ICAL_ENDPOINT_PREFIX + "/search/filter/events.ics" + "?_=" + System.currentTimeMillis() + "&searchFilterId=" + searchFilterId + JiraICalendarRestPathsConstructor.appendEndPointDateFieldNameParam(calendarOptions) + JiraICalendarRestPathsConstructor.appendEndPointFixVersionParam(calendarOptions) + JiraICalendarRestPathsConstructor.appendEndPointRangeDateLimit(start, end);
    }

    static String getDateFieldsListEndPoint(String jql, boolean isUsingExpandedFieldRetrieval) {
        return "/rest/ical/1.0/ical/config/fields?jql=" + HtmlUtil.urlEncode((String)jql) + "&useExpandedFieldRetrieval=" + isUsingExpandedFieldRetrieval;
    }

    static String getDateFieldsListEndPoint(long searchFilterId, boolean isUsingExpandedFieldRetrieval) {
        return "/rest/ical/1.0/ical/config/fields?searchRequestId=" + searchFilterId + "&useExpandedFieldRetrieval=" + isUsingExpandedFieldRetrieval;
    }

    private static String appendEndPointFixVersionParam(JiraAccessor.CalendarOptions calendarOptions) {
        return "&includeFixVersions=" + calendarOptions.isIncludeFixVersions();
    }

    private static StringBuilder appendEndPointRangeDateLimit(long start, long end) {
        return new StringBuilder().append("&start=").append(start).append("&end=").append(end).append("&maxIssue=").append(CalendarUtil.MAX_JIRA_ISSUES_TO_DISPLAY);
    }

    private static String appendEndPointDateFieldNameParam(JiraAccessor.CalendarOptions calendarOptions) {
        Set durations;
        StringBuilder sb = new StringBuilder();
        Set dateFieldNames = calendarOptions.getDateFieldNames();
        if (dateFieldNames != null) {
            for (String dateFieldName : dateFieldNames) {
                sb.append("&dateFieldName=").append(HtmlUtil.urlEncode((String)JiraICalendarRestPathsConstructor.rekeyDateField(dateFieldName)));
            }
        }
        if ((durations = calendarOptions.getDurations()) != null && !durations.isEmpty()) {
            StringBuilder durationsBuilder = new StringBuilder();
            for (PairType duration : durations) {
                durationsBuilder.setLength(0);
                durationsBuilder.append(JiraICalendarRestPathsConstructor.rekeyDateField(duration.getKey().toString())).append('/').append(JiraICalendarRestPathsConstructor.rekeyDateField(duration.getValue().toString()));
                sb.append("&duration=").append(HtmlUtil.urlEncode((String)durationsBuilder.toString()));
            }
        }
        return sb.toString();
    }

    private static String rekeyDateField(String dateFieldKey) {
        return StringUtils.equals((CharSequence)"resolution", (CharSequence)dateFieldKey) ? "resolutiondate" : dateFieldKey;
    }
}

