/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.event.transformers;

import com.atlassian.confluence.extra.calendar3.calendarstore.event.transformers.SubCalendarEventTransformerFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.event.transformers.WebResourceDependentSubCalendarEventTransformer;
import com.atlassian.confluence.extra.calendar3.model.CustomEventType;
import com.atlassian.confluence.extra.calendar3.model.ReminderEvent;
import com.atlassian.confluence.extra.calendar3.model.ReminderSubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.model.SubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.util.BuildInformationManager;
import com.atlassian.confluence.extra.calendar3.util.CalendarUtil;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ReminderSubCalendarEventTransformer
extends WebResourceDependentSubCalendarEventTransformer<SubCalendarEventTransformerFactory.TransformParameters> {
    public ReminderSubCalendarEventTransformer(LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, BuildInformationManager buildInformationManager) {
        super(localeManager, i18NBeanFactory, buildInformationManager);
    }

    @Override
    public SubCalendarEvent transform(SubCalendarEvent toBeTransformed, ConfluenceUser forUser, SubCalendarEventTransformerFactory.TransformParameters transformParameters) {
        if (!(toBeTransformed instanceof ReminderSubCalendarEvent)) {
            return toBeTransformed;
        }
        if (!(transformParameters instanceof SubCalendarEventTransformerFactory.ReminderTransformParameters)) {
            return toBeTransformed;
        }
        ReminderSubCalendarEvent reminderSubCalendarEventToBeTransformed = (ReminderSubCalendarEvent)toBeTransformed;
        SubCalendarEventTransformerFactory.ReminderTransformParameters reminderTransformParameters = (SubCalendarEventTransformerFactory.ReminderTransformParameters)transformParameters;
        SubCalendarEventTransformerFactory subCalendarEventTransformerFactory = reminderTransformParameters.getSubCalendarEventTransformerFactory();
        toBeTransformed = subCalendarEventTransformerFactory.getDefaultTransformer().transform(toBeTransformed, forUser, transformParameters);
        CustomEventType customEventType = this.findCustomEventTypeById(toBeTransformed.getCustomEventTypeId(), reminderTransformParameters.getAvailableCustomEventTypes());
        ReminderEvent reminderEvent = reminderSubCalendarEventToBeTransformed.getReminderEvent();
        boolean needReformatResourceUrl = false;
        if (CalendarUtil.isJiraStoreKey(reminderEvent.getStoreKey())) {
            reminderSubCalendarEventToBeTransformed.setIconUrl(reminderEvent.getIconUrl());
            reminderSubCalendarEventToBeTransformed.setMediumIconUrl(reminderEvent.getMediumIconUrl());
            reminderSubCalendarEventToBeTransformed.setEventTypeIconUrl(reminderEvent.getIconUrl());
            needReformatResourceUrl = true;
        } else if (toBeTransformed.getInvitees() != null && !toBeTransformed.getInvitees().isEmpty()) {
            toBeTransformed = subCalendarEventTransformerFactory.getInviteesTransformer().transform(toBeTransformed, forUser, transformParameters);
            needReformatResourceUrl = true;
        } else if (customEventType == null) {
            toBeTransformed = subCalendarEventTransformerFactory.getNoInviteesTransformer().transform(toBeTransformed, forUser, transformParameters);
            needReformatResourceUrl = true;
        } else {
            toBeTransformed.setIconUrl(String.format("com/atlassian/confluence/extra/calendar3/img/customeventtype/%s_48.png", customEventType.getIcon()));
            toBeTransformed.setMediumIconUrl(String.format("com/atlassian/confluence/extra/calendar3/img/customeventtype/%s_24.png", customEventType.getIcon()));
            reminderSubCalendarEventToBeTransformed.setEventTypeIconUrl(toBeTransformed.getIconUrl());
        }
        if (StringUtils.isNotEmpty((CharSequence)toBeTransformed.getIconUrl()) && needReformatResourceUrl) {
            toBeTransformed.setIconUrl(String.format("com/atlassian/confluence/extra/calendar3/%s", this.getSubIconUrl(toBeTransformed.getIconUrl())));
            toBeTransformed.setMediumIconUrl(String.format("com/atlassian/confluence/extra/calendar3/%s", this.getSubIconUrl(toBeTransformed.getIconUrl())));
        }
        return toBeTransformed;
    }

    private CustomEventType findCustomEventTypeById(String currentCustomEventTypeId, Collection<CustomEventType> customEventTypes) {
        if (StringUtils.isEmpty((CharSequence)currentCustomEventTypeId)) {
            return null;
        }
        for (CustomEventType customEventType : customEventTypes) {
            if (!currentCustomEventTypeId.equals(customEventType.getCustomEventTypeId())) continue;
            return customEventType;
        }
        return null;
    }

    private String getSubIconUrl(String fullIconUrl) {
        if (StringUtils.isEmpty((CharSequence)fullIconUrl)) {
            return "";
        }
        String[] urlParts = fullIconUrl.split("/");
        if (urlParts == null || urlParts.length < 2) {
            return fullIconUrl;
        }
        return String.format("%s/%s", urlParts[urlParts.length - 2], urlParts[urlParts.length - 1]);
    }
}

