/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.filtermappers;

import com.atlassian.confluence.extra.calendar3.caldav.filter.EntityTimeRangeFilter;
import com.atlassian.confluence.extra.calendar3.calendarstore.filtermappers.AbstractPropertyOperationMapper;
import com.atlassian.confluence.extra.calendar3.calendarstore.filtermappers.PropertyToDBFieldMapperSupplier;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import org.bedework.caldav.util.TimeRange;
import org.bedework.util.calendar.PropertyIndex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityTimeRangeOperationMapper
extends AbstractPropertyOperationMapper<EntityTimeRangeFilter> {
    @Autowired
    public EntityTimeRangeOperationMapper(PropertyToDBFieldMapperSupplier propertyToDBFieldMapperSupplier) {
        super(propertyToDBFieldMapperSupplier);
    }

    @Override
    public BooleanBuilder apply(EntityTimeRangeFilter entityTimeRangeFilter) {
        Object propertyToDBFieldMapper = this.propertyToDBFieldMapperSupplier.get();
        NumberPath startField = (NumberPath)propertyToDBFieldMapper.get(PropertyIndex.PropertyInfoIndex.DTSTART);
        NumberPath endField = (NumberPath)propertyToDBFieldMapper.get(PropertyIndex.PropertyInfoIndex.DTEND);
        TimeRange timeRange = (TimeRange)entityTimeRangeFilter.getEntity();
        if (timeRange.getStart() == null && timeRange.getEnd() != null) {
            long endTimeUTC = timeRange.getEnd().getTime();
            return new BooleanBuilder((Predicate)startField.lt((Number)endTimeUTC));
        }
        if (timeRange.getEnd() == null && timeRange.getStart() != null) {
            long startTimeUTC = timeRange.getStart().getTime();
            return new BooleanBuilder((Predicate)endField.gt((Number)startTimeUTC));
        }
        long startTimeUTC = timeRange.getStart().getTime();
        long endTimeUTC = timeRange.getEnd().getTime();
        BooleanBuilder booleanBuilder = new BooleanBuilder((Predicate)startField.lt((Number)endTimeUTC));
        booleanBuilder.and((Predicate)endField.gt((Number)startTimeUTC));
        booleanBuilder.or((Predicate)startField.eq((Expression)endField).and((Predicate)endField.goe((Number)startTimeUTC)));
        return booleanBuilder;
    }
}

