/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.confluence.extra.calendar3.util.Ical4jIoUtil;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseResponseHandler<T>
implements ApplicationLinkResponseHandler<T> {
    final ApplicationLinkRequestFactory requestFactory;

    public BaseResponseHandler(ApplicationLinkRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public T credentialsRequired(Response response) throws ResponseException {
        throw new ResponseException((Throwable)new CredentialsRequiredException((AuthorisationURIGenerator)this.requestFactory, ""));
    }

    public abstract T handle(Response var1) throws ResponseException;

    static String readResponseToString(Response response) throws ResponseException, IOException {
        if (response.isSuccessful()) {
            try (BufferedInputStream inputStream = new BufferedInputStream(response.getResponseBodyAsStream());){
                String string = IOUtils.toString((InputStream)inputStream, (String)Ical4jIoUtil.getContentTypeCharset(response.getHeader("Content-Type")));
                return string;
            }
        }
        throw new ResponseException(String.format("%d - %s", response.getStatusCode(), StringUtils.defaultString((String)response.getStatusText())));
    }
}

