/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.model.JqlAutoCompleteResult;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetAutoCompleteResponseHandler
extends BaseResponseHandler<JqlAutoCompleteResult> {
    private final String endPoint;

    public GetAutoCompleteResponseHandler(ApplicationLinkRequestFactory requestFactory, String endPoint) {
        super(requestFactory);
        this.endPoint = endPoint;
    }

    @Override
    public JqlAutoCompleteResult handle(Response response) throws ResponseException {
        if (!response.isSuccessful()) {
            throw new JiraAccessor.JiraResponseException(String.format("The response from %s didn't make sense", this.endPoint));
        }
        try {
            return this.getJqlAutoCompleteResult(GetAutoCompleteResponseHandler.readResponseToString(response));
        }
        catch (IOException | JSONException invalidJsonFromJira) {
            throw new ResponseException(String.format("The response from %s didn't make sense", this.endPoint), invalidJsonFromJira);
        }
    }

    private JqlAutoCompleteResult getJqlAutoCompleteResult(String resultsJson) {
        JSONArray resultsArray;
        JSONObject resultsObject = new JSONObject(resultsJson);
        ArrayList<JqlAutoCompleteResult.Result> results = new ArrayList<JqlAutoCompleteResult.Result>();
        if (resultsObject.has("results") && (resultsArray = resultsObject.getJSONArray("results")) != null) {
            int j = resultsArray.length();
            for (int i = 0; i < j; ++i) {
                JSONObject aResult = resultsArray.getJSONObject(i);
                results.add(new JqlAutoCompleteResult.Result(aResult.getString("displayName"), aResult.getString("value")));
            }
        }
        return new JqlAutoCompleteResult(results);
    }
}

