/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;

public class GetCalendarFromEndPointResponseHandler
extends BaseResponseHandler<String> {
    private final ApplicationLink jiraLink;
    private final String jql;
    private final String endPoint;

    public GetCalendarFromEndPointResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, String jql, String endPoint) {
        super(requestFactory);
        this.jiraLink = jiraLink;
        this.jql = jql;
        this.endPoint = endPoint;
    }

    @Override
    public String handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return GetCalendarFromEndPointResponseHandler.readResponseToString(response);
            }
            catch (IOException io) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.jql), (Throwable)io);
            }
        }
        if (response.getStatusCode() == 404) {
            throw new JiraAccessor.JiraPreConditionUnmetException(this.jiraLink, JiraAccessor.JiraPreConditionUnmetException.PreCondition.EndpointNotFound, this.endPoint);
        }
        if (response.getStatusCode() == 400) {
            throw new JiraAccessor.JiraJQLWrongResponseException(String.format("The JQL query for %s didn't return any results. Try changing the query.", this.jql));
        }
        throw new JiraAccessor.JiraResponseException(String.format("The response from %s didn't make sense", this.jql));
    }
}

