/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.model.JiraDateField;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDateFieldsInternalResponseHandler
extends BaseResponseHandler<Collection<JiraDateField>> {
    private static final Logger LOG = LoggerFactory.getLogger(GetDateFieldsInternalResponseHandler.class);
    private final String jql;

    public GetDateFieldsInternalResponseHandler(ApplicationLinkRequestFactory requestFactory, String jql) {
        super(requestFactory);
        this.jql = jql;
    }

    @Override
    public Collection<JiraDateField> handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return this.getJiraDateFields(GetDateFieldsInternalResponseHandler.readResponseToString(response));
            }
            catch (IOException | JSONException exception) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.jql), exception);
            }
        }
        if (response.getStatusCode() == 404) {
            return Set.of();
        }
        throw new JiraAccessor.JiraResponseException(String.format("The response from %s didn't make sense", this.jql));
    }

    private List<JiraDateField> getJiraDateFields(String dateFieldsJson) {
        JSONArray dateFieldsCollection = new JSONArray(dateFieldsJson);
        ArrayList<JiraDateField> jiraDateFields = new ArrayList<JiraDateField>();
        int j = dateFieldsCollection.length();
        for (int i = 0; i < j; ++i) {
            JSONObject dateFieldJson = (JSONObject)dateFieldsCollection.get(i);
            jiraDateFields.add(new JiraDateField(dateFieldJson.getString("key"), dateFieldJson.getString("name"), dateFieldJson.optBoolean("hasSearcher", true)));
        }
        if (LOG.isDebugEnabled()) {
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            for (JiraDateField jiraDateField : jiraDateFields) {
                JSONObject toJson = jiraDateField.toJson();
                joiner.add(toJson.toString());
            }
            LOG.debug("Date fields retrieved from Jira: {}", (Object)joiner);
        }
        return jiraDateFields;
    }
}

