/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.JodaIcal4jDateTimeConverter;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.ical4j.property.GreenHopperSprintEditability;
import com.atlassian.confluence.extra.calendar3.ical4j.property.GreenHopperSprintStatus;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.net.URI;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetGreenHopperSprintDatesForJqlResponseHandler
extends BaseResponseHandler<ComponentList> {
    private final ApplicationLink jiraLink;
    private final String jql;
    private final JodaIcal4jDateTimeConverter jodaIcal4jDateTimeConverter;

    public GetGreenHopperSprintDatesForJqlResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, String jql, JodaIcal4jDateTimeConverter jodaIcal4jDateTimeConverter) {
        super(requestFactory);
        this.jiraLink = jiraLink;
        this.jql = jql;
        this.jodaIcal4jDateTimeConverter = jodaIcal4jDateTimeConverter;
    }

    @Override
    public ComponentList handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return this.getSprintDatesAsVEvents(this.jiraLink.getDisplayUrl(), new JSONObject(GetGreenHopperSprintDatesForJqlResponseHandler.readResponseToString(response)));
            }
            catch (JSONException invalidJsonFromJira) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.jql), (Throwable)invalidJsonFromJira);
            }
            catch (IOException io) {
                throw new ResponseException((Throwable)io);
            }
        }
        throw new JiraAccessor.JiraResponseException(String.format("The response from %s didn't make sense", this.jql));
    }

    private ComponentList getSprintDatesAsVEvents(URI jiraDisplay, JSONObject greenHopperResponseObj) throws JSONException {
        DateTimeZone dateTimeZone = DateTimeZone.forID((String)greenHopperResponseObj.getString("jodaTimeZoneId"));
        JSONArray sprintsArray = greenHopperResponseObj.getJSONArray("sprints");
        ComponentList sprintVEventObjects = new ComponentList();
        int j = sprintsArray.length();
        for (int i = 0; i < j; ++i) {
            JSONObject sprintEventObj = sprintsArray.getJSONObject(i);
            VEvent aSprintEvent = new VEvent((Date)this.jodaIcal4jDateTimeConverter.toIcal4jDateTime(this.getGreenHopperSprintDateAsDateTime(sprintEventObj.getString("start"), dateTimeZone)), (Date)this.jodaIcal4jDateTimeConverter.toIcal4jDateTime(this.getGreenHopperSprintDateAsDateTime(sprintEventObj.getString("end"), dateTimeZone)), sprintEventObj.getString("name"));
            PropertyList vEventProperties = aSprintEvent.getProperties();
            vEventProperties.add((Property)new Uid(String.format("%d@%s", sprintEventObj.getLong("id"), jiraDisplay.getHost())));
            if (sprintEventObj.has("description")) {
                vEventProperties.add((Property)new Description(StringUtils.defaultString((String)sprintEventObj.getString("description"))));
            }
            vEventProperties.add((Property)(sprintEventObj.getBoolean("closed") ? GreenHopperSprintStatus.CLOSED : GreenHopperSprintStatus.OPEN));
            vEventProperties.add((Property)(sprintEventObj.getBoolean("editable") ? GreenHopperSprintEditability.EDITABLE : GreenHopperSprintEditability.NOT_EDITABLE));
            if (sprintEventObj.has("projects")) {
                JSONArray projectsArray = sprintEventObj.getJSONArray("projects");
                int l = projectsArray.length();
                for (int k = 0; k < l; ++k) {
                    JSONObject projectObj = projectsArray.getJSONObject(k);
                    ParameterList parameterList = new ParameterList();
                    XParameter jiraProject = new XParameter("X-JIRA-PROJECT-KEY", projectObj.getString("key"));
                    parameterList.add((Parameter)jiraProject);
                    vEventProperties.add((Property)new XProperty("X-JIRA-PROJECT", parameterList, projectObj.getString("name")));
                }
            }
            if (sprintEventObj.has("viewBoardsUrl")) {
                vEventProperties.add((Property)new XProperty("X-GREENHOPPER-SPRINT-VIEWBOARDS-URL", sprintEventObj.getString("viewBoardsUrl")));
            }
            if (sprintEventObj.has("sprintHomePageUrl")) {
                vEventProperties.add((Property)new XProperty("X-GREENHOPPER-SPRINT-HOMEPAGE-URL", sprintEventObj.getString("sprintHomePageUrl")));
            }
            sprintVEventObjects.add((Object)aSprintEvent);
        }
        return sprintVEventObjects;
    }

    private DateTime getGreenHopperSprintDateAsDateTime(String date, DateTimeZone dateTimeZone) {
        return new DateTime(Integer.parseInt(date.substring(4, 8)), Integer.parseInt(date.substring(2, 4)), Integer.parseInt(date.substring(0, 2)), Integer.parseInt(date.substring(8, 10)), Integer.parseInt(date.substring(10, 12)), 0, 0, dateTimeZone);
    }
}

