/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.util.CalendarUtil;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetIssueCountWithJiraApiResponseHandler
extends BaseResponseHandler<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(GetIssueCountWithJiraApiResponseHandler.class);
    private final String endPoint;
    private final String jql;

    public GetIssueCountWithJiraApiResponseHandler(ApplicationLinkRequestFactory requestFactory, String jql, String endPoint) {
        super(requestFactory);
        this.jql = jql;
        this.endPoint = endPoint;
    }

    @Override
    public Integer handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return new JSONObject(GetIssueCountWithJiraApiResponseHandler.readResponseToString(response)).getInt(this.getCountAttributeName());
            }
            catch (JSONException invalidJsonFromJira) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.endPoint), (Throwable)invalidJsonFromJira);
            }
            catch (IOException io) {
                throw new ResponseException((Throwable)io);
            }
        }
        LOG.warn("Unable to get total results from JQL \"{}\": HTTP {}", (Object)this.jql, (Object)response.getStatusCode());
        return CalendarUtil.MAX_JIRA_ISSUES_TO_DISPLAY;
    }

    protected String getCountAttributeName() {
        return "total";
    }
}

