/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class GetIssuesReturnedByJqlResponseHandler
extends BaseResponseHandler<Integer> {
    private final ApplicationLink jiraLink;
    private final String endPoint;

    public GetIssuesReturnedByJqlResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, String endPoint) {
        super(requestFactory);
        this.jiraLink = jiraLink;
        this.endPoint = endPoint;
    }

    @Override
    public Integer handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return new JSONObject(GetIssuesReturnedByJqlResponseHandler.readResponseToString(response)).getInt("total");
            }
            catch (JSONException invalidJsonFromJira) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.endPoint), (Throwable)invalidJsonFromJira);
            }
            catch (IOException io) {
                throw new ResponseException((Throwable)io);
            }
        }
        if (response.getStatusCode() == 404) {
            throw new JiraAccessor.JiraPreConditionUnmetException(this.jiraLink, JiraAccessor.JiraPreConditionUnmetException.PreCondition.EndpointNotFound, this.endPoint);
        }
        throw new ResponseException(String.format("Unable to validate calendar against JIRA. JIRA responded with: HTTP %d", response.getStatusCode()));
    }
}

