/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.model.Project;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class GetProjectResponseHandler
extends BaseResponseHandler<Project> {
    private final ApplicationLink jiraLink;
    private final String endPoint;

    public GetProjectResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, String endPoint) {
        super(requestFactory);
        this.jiraLink = jiraLink;
        this.endPoint = endPoint;
    }

    @Override
    public Project handle(Response response) throws ResponseException {
        if (response.getStatusCode() == 404) {
            throw new JiraAccessor.JiraPreConditionUnmetException(this.jiraLink, JiraAccessor.JiraPreConditionUnmetException.PreCondition.EndpointNotFound, this.endPoint);
        }
        try {
            JSONObject projectJSON = new JSONObject(GetProjectResponseHandler.readResponseToString(response));
            return new Project(projectJSON.getString("key"), projectJSON.getString("name"));
        }
        catch (IOException io) {
            throw new ResponseException(String.format("The response from %s didn't make sense", this.endPoint), (Throwable)io);
        }
        catch (JSONException json) {
            throw new ResponseException(String.format("Unable to interpret response from %s%s in the expected JSON format", this.jiraLink.getDisplayUrl().toString(), this.endPoint), (Throwable)json);
        }
    }
}

