/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class GetSearchFilterJqlResponseHandler
extends BaseResponseHandler<String> {
    private final ApplicationLink jiraLink;
    private final String endPoint;

    public GetSearchFilterJqlResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, String endPoint) {
        super(requestFactory);
        this.jiraLink = jiraLink;
        this.endPoint = endPoint;
    }

    @Override
    public String handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return new JSONObject(GetSearchFilterJqlResponseHandler.readResponseToString(response)).getString("jql");
            }
            catch (JSONException invalidJsonFromJira) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.endPoint), (Throwable)invalidJsonFromJira);
            }
            catch (IOException io) {
                throw new ResponseException((Throwable)io);
            }
        }
        if (response.getStatusCode() == 404) {
            throw new JiraAccessor.JiraPreConditionUnmetException(this.jiraLink, JiraAccessor.JiraPreConditionUnmetException.PreCondition.EndpointNotFound, this.endPoint);
        }
        throw new JiraAccessor.JiraPreConditionUnmetException(this.jiraLink, JiraAccessor.JiraPreConditionUnmetException.PreCondition.InvalidSearchFilter, this.endPoint);
    }
}

