/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.JiraAccessor;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.model.JqlValidationResult;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JqlValidationResultResponseHandler
extends BaseResponseHandler<JqlValidationResult> {
    private final String jql;

    public JqlValidationResultResponseHandler(ApplicationLinkRequestFactory requestFactory, String jql) {
        super(requestFactory);
        this.jql = jql;
    }

    @Override
    public JqlValidationResult handle(Response response) throws ResponseException {
        if (response.isSuccessful()) {
            try {
                return JqlValidationResultResponseHandler.getJqlValidationResult(JqlValidationResultResponseHandler.readResponseToString(response));
            }
            catch (IOException | JSONException exception) {
                throw new ResponseException(String.format("The response from %s didn't make sense", this.jql), exception);
            }
        }
        if (response.getStatusCode() == 404) {
            return new JqlValidationResult();
        }
        throw new JiraAccessor.JiraResponseException(String.format("The response from %s didn't make sense", this.jql));
    }

    private static JqlValidationResult getJqlValidationResult(String validationResultsJson) {
        int i;
        int j;
        JSONObject validationResultsObj = new JSONObject(validationResultsJson);
        JqlValidationResult jqlValidationResult = new JqlValidationResult();
        if (validationResultsObj.has("warningMessages")) {
            LinkedHashSet<String> warningMessages = new LinkedHashSet<String>();
            JSONArray warningMessagesArray = validationResultsObj.getJSONArray("warningMessages");
            j = warningMessagesArray.length();
            for (i = 0; i < j; ++i) {
                warningMessages.add(warningMessagesArray.getString(i));
            }
            jqlValidationResult.setWarningMessages(warningMessages);
        }
        if (validationResultsObj.has("errorMessages")) {
            LinkedHashSet<String> errorMessages = new LinkedHashSet<String>();
            JSONArray errorMessagesArray = validationResultsObj.getJSONArray("errorMessages");
            j = errorMessagesArray.length();
            for (i = 0; i < j; ++i) {
                errorMessages.add(errorMessagesArray.getString(i));
            }
            jqlValidationResult.setErrorMessages(errorMessages);
        }
        return jqlValidationResult;
    }
}

