/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.handlers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.confluence.extra.calendar3.calendarstore.handlers.BaseResponseHandler;
import com.atlassian.confluence.extra.calendar3.exception.CalendarException;
import com.atlassian.core.util.PairType;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Collections2;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UpdateEventFieldsResponseHandler
extends BaseResponseHandler<Void> {
    private final ApplicationLink jiraLink;
    private final Map.Entry<String, List<PairType>> eventField;

    public UpdateEventFieldsResponseHandler(ApplicationLinkRequestFactory requestFactory, ApplicationLink jiraLink, Map.Entry<String, List<PairType>> eventField) {
        super(requestFactory);
        this.jiraLink = jiraLink;
        this.eventField = eventField;
    }

    @Override
    public Void handle(Response response) throws ResponseException {
        if (response.getStatusCode() == 400) {
            throw new CalendarException("calendar3.error.edit.jira.field.permission", UpdateEventFieldsResponseHandler.getFieldNames(this.eventField.getValue()), this.jiraLink.getName());
        }
        if (!response.isSuccessful()) {
            throw new CalendarException("calendar3.error.edit.jira.field", UpdateEventFieldsResponseHandler.getFieldNames(this.eventField.getValue()), this.jiraLink.getName(), response.getStatusCode());
        }
        return null;
    }

    public static String getFieldNames(List<PairType> fields) {
        return StringUtils.join((Iterable)Collections2.transform(fields, pairType -> pairType.getKey().toString()), (String)", ");
    }
}

