/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.calendarstore.supporters.jirareminder;

import com.atlassian.confluence.extra.calendar3.calendarstore.AbstractJiraSubCalendarDataStore;
import com.atlassian.confluence.extra.calendar3.model.AbstractJiraSubCalendar;
import com.atlassian.confluence.extra.calendar3.model.SubCalendarEvent;
import com.atlassian.confluence.extra.calendar3.querydsl.DTO.JiraReminderEventDTO;
import com.atlassian.confluence.extra.calendar3.util.CalendarUtil;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Summary;
import org.apache.commons.lang3.StringUtils;

public class JiraReminderEventDTOConverter<T extends AbstractJiraSubCalendar> {
    private final AbstractJiraSubCalendarDataStore<T> jiraSubCalendarDataStore;
    private final Supplier<ConfluenceUser> currentLoginUser;

    public JiraReminderEventDTOConverter(AbstractJiraSubCalendarDataStore<T> jiraSubCalendarDataStore, Supplier<ConfluenceUser> currentLoginUser) {
        this.jiraSubCalendarDataStore = jiraSubCalendarDataStore;
        this.currentLoginUser = currentLoginUser;
    }

    public List<JiraReminderEventDTO> convertJiraVEventToDTO(T subCalendar, List<VEvent> vEvents) {
        ArrayList<JiraReminderEventDTO> jiraReminderEventDTOs = new ArrayList<JiraReminderEventDTO>();
        for (VEvent vEvent : vEvents) {
            org.joda.time.DateTime endDateTimeUTC;
            org.joda.time.DateTime startDateTimeUTC;
            boolean isAllDay;
            Description descriptionProperty;
            JiraReminderEventDTO jiraReminderEventDTO = new JiraReminderEventDTO();
            ConfluenceUser currentUser = this.currentLoginUser.get();
            String userId = currentUser.getKey().toString();
            String keyId = userId + ":" + subCalendar.getId();
            jiraReminderEventDTO.setKeyId(keyId);
            jiraReminderEventDTO.setSubCalendarId(subCalendar.getId());
            jiraReminderEventDTO.setUserId(userId);
            jiraReminderEventDTO.setJql(subCalendar.getSourceLocation());
            jiraReminderEventDTO.setEventType(subCalendar.getType());
            Property issueKeyProperty = vEvent.getProperty("X-JIRA-ISSUE-KEY");
            Property statusFieldProperty = vEvent.getProperty("X-JIRA-STATUS");
            String issueKey = null == issueKeyProperty ? "" : StringUtils.defaultString((String)issueKeyProperty.getValue());
            String status = null == statusFieldProperty ? "" : StringUtils.defaultString((String)statusFieldProperty.getValue());
            jiraReminderEventDTO.setTicketId(issueKey);
            jiraReminderEventDTO.setStatus(status);
            jiraReminderEventDTO.setStoreKey(subCalendar.getStoreKey());
            Summary summaryProperty = vEvent.getSummary();
            if (null != summaryProperty) {
                if ("JIRA_PROJECT_RELEASES_SUB_CALENDAR_STORE".equals(jiraReminderEventDTO.getStoreKey())) {
                    String projectName = CalendarUtil.getProjectNameFromJiraRawEvent(vEvent);
                    jiraReminderEventDTO.setSummary((String)(StringUtils.isNotBlank((CharSequence)projectName) ? projectName + " - " + summaryProperty.getValue() : summaryProperty.getValue()));
                } else {
                    jiraReminderEventDTO.setSummary(summaryProperty.getValue());
                }
            }
            if (null != (descriptionProperty = vEvent.getDescription())) {
                jiraReminderEventDTO.setDescription(descriptionProperty.getValue());
            }
            Date startDate = vEvent.getStartDate().getDate();
            Date endDate = vEvent.getEndDate().getDate();
            boolean bl = isAllDay = !(startDate instanceof DateTime) && !(endDate instanceof DateTime);
            if (isAllDay) {
                startDateTimeUTC = CalendarUtil.getUtcDateTimeWithAllDay(startDate);
                endDateTimeUTC = CalendarUtil.getUtcDateTimeWithAllDay(endDate);
            } else {
                startDateTimeUTC = new org.joda.time.DateTime((Object)CalendarUtil.getUtcTime((DateProperty)vEvent.getStartDate()));
                endDateTimeUTC = new org.joda.time.DateTime((Object)CalendarUtil.getUtcTime((DateProperty)vEvent.getEndDate()));
            }
            jiraReminderEventDTO.setUtcStart(startDateTimeUTC.getMillis());
            jiraReminderEventDTO.setUtcEnd(endDateTimeUTC.getMillis());
            Property allDayEventProperty = vEvent.getProperty("EVENT-ALLDAY");
            if (null != allDayEventProperty) {
                jiraReminderEventDTO.setAllDay(Boolean.getBoolean(allDayEventProperty.getValue()));
            } else if (startDateTimeUTC.getHourOfDay() == 0 && startDateTimeUTC.getMinuteOfHour() == 0 && startDateTimeUTC.getSecondOfMinute() == 0 && endDateTimeUTC.getHourOfDay() == 0 && endDateTimeUTC.getMinuteOfDay() == 0 && endDateTimeUTC.getSecondOfMinute() == 0) {
                jiraReminderEventDTO.setAllDay(true);
            }
            Property assignee = vEvent.getProperty("X-JIRA-ASSIGNEE");
            if (null != assignee) {
                jiraReminderEventDTO.setAssignee(assignee.getValue());
            }
            SubCalendarEvent subCalendarEvent = new SubCalendarEvent();
            subCalendarEvent.setSubCalendar(subCalendar);
            subCalendarEvent.setStartTime(startDateTimeUTC);
            subCalendarEvent.setEndTime(endDateTimeUTC);
            subCalendarEvent = this.jiraSubCalendarDataStore.transformJiraEvent(subCalendarEvent, vEvent);
            if (subCalendarEvent != null && subCalendarEvent.getExtraProperties() != null && !subCalendarEvent.getExtraProperties().isEmpty()) {
                if ("greenhopper-sprint".equals(subCalendarEvent.getClassName())) {
                    jiraReminderEventDTO.setJiraIssueLink((String)subCalendarEvent.getExtraProperties().get("viewBoardsUrl"));
                } else if ("jira-issue".equals(subCalendarEvent.getClassName())) {
                    jiraReminderEventDTO.setJiraIssueLink((String)subCalendarEvent.getExtraProperties().get("issueLink"));
                } else {
                    jiraReminderEventDTO.setJiraIssueLink((String)subCalendarEvent.getExtraProperties().get("summaryLink"));
                }
                jiraReminderEventDTO.setJiraIssueIconUrl(subCalendarEvent.getIconUrl());
            }
            jiraReminderEventDTOs.add(jiraReminderEventDTO);
        }
        return jiraReminderEventDTOs;
    }
}

