/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.calendar3.contenttype;

import com.atlassian.confluence.content.ContentEntityAdapterParent;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.extra.calendar3.CalendarManager;
import com.atlassian.confluence.extra.calendar3.model.PersistedSubCalendar;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarContentEntityAdapter
extends ContentEntityAdapterParent {
    CalendarManager calendarManager;

    @Autowired
    public CalendarContentEntityAdapter(CalendarManager calendarManager) {
        this.calendarManager = calendarManager;
    }

    public Optional<String> urlPath(CustomContentEntityObject cceo) {
        if ("com.atlassian.confluence.extra.team-calendars:calendar-content-type".equals(cceo.getPluginModuleKey())) {
            String subCalendarId = this.getSubCalendarId(cceo);
            com.google.common.base.Optional subCalendarOption = this.calendarManager.getPersistedSubCalendar(subCalendarId);
            if (subCalendarOption.isPresent() && StringUtils.isNotBlank((CharSequence)((PersistedSubCalendar)subCalendarOption.get()).getSpaceKey())) {
                PersistedSubCalendar subCalendar = (PersistedSubCalendar)subCalendarOption.get();
                return Optional.of("/display/" + subCalendar.getSpaceKey() + "/calendar/" + subCalendarId + "?calendarName=" + subCalendar.getName());
            }
            return Optional.of("/calendar/previewcalendar.action?subCalendarId=" + subCalendarId);
        }
        return Optional.of("/display/" + this.getSpaceKey(cceo) + "/calendars");
    }

    public Optional<String> displayTitle(CustomContentEntityObject pluginContentEntityObject) {
        return Optional.of(pluginContentEntityObject.getTitle());
    }

    public BodyType getDefaultBodyType(CustomContentEntityObject pluginContentEntityObject) {
        return BodyType.XHTML;
    }

    public Optional<String> excerpt(CustomContentEntityObject pluginContentEntityObject) {
        return Optional.of(pluginContentEntityObject.getBodyAsString());
    }

    public boolean isIndexable(CustomContentEntityObject pluginContentEntityObject, boolean isDefaultIndexable) {
        return true;
    }

    public String getSubCalendarId(CustomContentEntityObject pluginContentEntityObject) {
        return pluginContentEntityObject.getProperties().getStringProperty("subCalendarId");
    }

    private String getSpaceKey(CustomContentEntityObject pluginContentEntityObject) {
        return pluginContentEntityObject.getProperties().getStringProperty("spaceKey");
    }
}

